/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.OAIDRom;
import com.github.gzuliyujiang.oaid.impl.AsusImpl;
import com.github.gzuliyujiang.oaid.impl.DefaultImpl;
import com.github.gzuliyujiang.oaid.impl.GmsImpl;
import com.github.gzuliyujiang.oaid.impl.HuaweiImpl;
import com.github.gzuliyujiang.oaid.impl.LenovoImpl;
import com.github.gzuliyujiang.oaid.impl.MeizuImpl;
import com.github.gzuliyujiang.oaid.impl.MsaImpl;
import com.github.gzuliyujiang.oaid.impl.NubiaImpl;
import com.github.gzuliyujiang.oaid.impl.OppoImpl;
import com.github.gzuliyujiang.oaid.impl.SamsungImpl;
import com.github.gzuliyujiang.oaid.impl.VivoImpl;
import com.github.gzuliyujiang.oaid.impl.XiaomiImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class OAIDFactory {
    private static IOAID ioaid;

    private OAIDFactory() {
    }

    public static IOAID create(@NonNull Context context) {
        if (!(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        if (ioaid == null) {
            if (OAIDRom.isLenovo() || OAIDRom.isMotolora()) {
                ioaid = new LenovoImpl(context);
            } else if (OAIDRom.isMeizu()) {
                ioaid = new MeizuImpl(context);
            } else if (OAIDRom.isNubia()) {
                ioaid = new NubiaImpl(context);
            } else if (OAIDRom.isXiaomi() || OAIDRom.isMiui() || OAIDRom.isBlackShark()) {
                ioaid = new XiaomiImpl(context);
            } else if (OAIDRom.isSamsung()) {
                ioaid = new SamsungImpl(context);
            } else if (OAIDRom.isVivo()) {
                ioaid = new VivoImpl(context);
            } else if (OAIDRom.isASUS()) {
                ioaid = new AsusImpl(context);
            } else if (OAIDRom.isHuawei() || OAIDRom.isEmui()) {
                ioaid = new HuaweiImpl(context);
            } else if (OAIDRom.isOppo() || OAIDRom.isOnePlus()) {
                ioaid = new OppoImpl(context);
            }
        }
        if (ioaid == null || !ioaid.supported()) {
            ioaid = new MsaImpl(context);
            if (ioaid.supported()) {
                OAIDLog.print("Mobile Security Alliance has been found");
            } else {
                ioaid = new GmsImpl(context);
                if (ioaid.supported()) {
                    OAIDLog.print("Google Play Service has been found");
                } else {
                    ioaid = new DefaultImpl();
                }
            }
        }
        return ioaid;
    }
}

