/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.OAIDRom;
import java.util.Objects;

class VivoImpl
implements IOAID {
    private final Context context;

    public VivoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        return OAIDRom.sysProperty("persist.sys.identifierid.supported", "0").equals("1");
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        block15: {
            Uri uri = Uri.parse((String)"content://com.vivo.vms.IdProvider/IdentifierId/OAID");
            try (Cursor cursor = this.context.getContentResolver().query(uri, null, null, null, null);){
                Objects.requireNonNull(cursor).moveToFirst();
                String ret = cursor.getString(cursor.getColumnIndex("value"));
                if (ret != null && ret.length() > 0) {
                    OAIDLog.print("oaid from provider: " + uri);
                    getter.onOAIDGetComplete(ret);
                    break block15;
                }
                throw new RuntimeException("OAID query failed");
            }
            catch (Throwable e) {
                OAIDLog.print(e);
                getter.onOAIDGetError(e);
            }
        }
    }
}

