/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.lang.reflect.Method;
import repeackage.com.samsung.android.deviceidservice.IDeviceIdService;

class SamsungImpl
implements IOAID {
    private final Context context;

    public SamsungImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.samsung.android.deviceidservice", 0);
            return pi != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent();
        intent.setClassName("com.samsung.android.deviceidservice", "com.samsung.android.deviceidservice.DeviceIdService");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    OAIDLog.print("Samsung DeviceIdService connected");
                    try {
                        Method asInterface = IDeviceIdService.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                        IDeviceIdService anInterface = (IDeviceIdService)asInterface.invoke(null, service);
                        if (anInterface == null) {
                            throw new RuntimeException("IDeviceIdService is null");
                        }
                        String oaid = anInterface.getOAID();
                        if (oaid == null || oaid.length() == 0) {
                            throw new RuntimeException("Samsung oaid get failed");
                        }
                        getter.onOAIDGetComplete(oaid);
                    }
                    catch (Throwable e) {
                        OAIDLog.print(e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        try {
                            SamsungImpl.this.context.unbindService((ServiceConnection)this);
                        }
                        catch (Throwable e) {
                            OAIDLog.print(e);
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    OAIDLog.print("Samsung DeviceIdService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("Samsung DeviceIdService bind failed");
            }
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }
}

