/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDRom;
import com.github.gzuliyujiang.oaid.impl.AsusImpl;
import com.github.gzuliyujiang.oaid.impl.DefaultImpl;
import com.github.gzuliyujiang.oaid.impl.HuaweiImpl;
import com.github.gzuliyujiang.oaid.impl.LenovoImpl;
import com.github.gzuliyujiang.oaid.impl.MeizuImpl;
import com.github.gzuliyujiang.oaid.impl.MsaImpl;
import com.github.gzuliyujiang.oaid.impl.NubiaImpl;
import com.github.gzuliyujiang.oaid.impl.OppoImpl;
import com.github.gzuliyujiang.oaid.impl.SamsungImpl;
import com.github.gzuliyujiang.oaid.impl.VivoImpl;
import com.github.gzuliyujiang.oaid.impl.XiaomiImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class OAIDFactory {
    private static IOAID ioaid;

    private OAIDFactory() {
    }

    public static IOAID create(@NonNull Context context) {
        if (!(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        if (ioaid == null) {
            ioaid = OAIDRom.isLenovo() || OAIDRom.isMotolora() ? new LenovoImpl(context) : (OAIDRom.isMeizu() ? new MeizuImpl(context) : (OAIDRom.isNubia() ? new NubiaImpl(context) : (OAIDRom.isXiaomi() || OAIDRom.isBlackShark() ? new XiaomiImpl(context) : (OAIDRom.isSamsung() ? new SamsungImpl(context) : (OAIDRom.isVivo() ? new VivoImpl(context) : (OAIDRom.isASUS() ? new AsusImpl(context) : (OAIDRom.isHuawei() ? new HuaweiImpl(context) : (OAIDRom.isOppo() || OAIDRom.isOnePlus() ? new OppoImpl(context) : (OAIDRom.isZTE() || OAIDRom.isFreeme() || OAIDRom.isSSUI() ? new MsaImpl(context) : new DefaultImpl())))))))));
        }
        return ioaid;
    }
}

