/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.lang.reflect.Method;
import repeackage.com.zui.deviceidservice.IDeviceidInterface;

class LenovoImpl
implements IOAID {
    private final Context context;

    public LenovoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.zui.deviceidservice", 0);
            return pi != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent();
        intent.setClassName("com.zui.deviceidservice", "com.zui.deviceidservice.DeviceidService");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    OAIDLog.print("Lenovo DeviceidService connected");
                    try {
                        Method asInterface = IDeviceidInterface.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                        IDeviceidInterface anInterface = (IDeviceidInterface)asInterface.invoke(null, service);
                        if (anInterface == null) {
                            throw new RuntimeException("IDeviceidInterface is null");
                        }
                        String oaid = anInterface.getOAID();
                        if (oaid == null || oaid.length() == 0) {
                            throw new RuntimeException("Lenovo OAID get failed");
                        }
                        getter.onOAIDGetComplete(oaid);
                    }
                    catch (Throwable e) {
                        OAIDLog.print(e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        try {
                            LenovoImpl.this.context.unbindService((ServiceConnection)this);
                        }
                        catch (Throwable e) {
                            OAIDLog.print(e);
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    OAIDLog.print("Lenovo DeviceidService disconnected");
                }
            }, 1);
            if (!isBinded) {
                getter.onOAIDGetError(new RuntimeException("Lenovo DeviceidService bind failed"));
            }
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }
}

