/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.lang.reflect.Method;
import repeackage.com.asus.msa.SupplementaryDID.IDidAidlInterface;

class AsusImpl
implements IOAID {
    private final Context context;

    public AsusImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.asus.msa.SupplementaryDID", 0);
            return pi != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent("com.asus.msa.action.ACCESS_DID");
        ComponentName componentName = new ComponentName("com.asus.msa.SupplementaryDID", "com.asus.msa.SupplementaryDID.SupplementaryDIDService");
        intent.setComponent(componentName);
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    OAIDLog.print("ASUS SupplementaryDIDService connected");
                    try {
                        Method asInterface = IDidAidlInterface.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                        IDidAidlInterface anInterface = (IDidAidlInterface)asInterface.invoke(null, service);
                        if (anInterface == null) {
                            throw new RuntimeException("IDidAidlInterface is null");
                        }
                        String ID = anInterface.getID();
                        if (ID == null || ID.length() == 0) {
                            throw new RuntimeException("ASUS ID get failed");
                        }
                        getter.onOAIDGetComplete(ID);
                    }
                    catch (Throwable e) {
                        OAIDLog.print(e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        try {
                            AsusImpl.this.context.unbindService((ServiceConnection)this);
                        }
                        catch (Throwable e) {
                            OAIDLog.print(e);
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    OAIDLog.print("ASUS SupplementaryDIDService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("ASUS SupplementaryDIDService bind failed");
            }
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }
}

