/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.MediaDrm;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.UUID;

public final class DeviceID {
    private static String clientId;
    private static String oaid;

    private DeviceID() {
    }

    public static void register(final Application application) {
        String uniqueID = DeviceID.getUniqueID((Context)application);
        if (!TextUtils.isEmpty((CharSequence)uniqueID)) {
            clientId = uniqueID;
            OAIDLog.print("Client id is IMEI/MEID");
            return;
        }
        DeviceID.getOAID((Context)application, new IGetter(){

            @Override
            public void onOAIDGetComplete(@NonNull String result) {
                clientId = result;
                oaid = result;
                OAIDLog.print("Client id is OAID");
            }

            @Override
            public void onOAIDGetError(@NonNull Throwable error) {
                String id = DeviceID.getWidevineID();
                if (!TextUtils.isEmpty((CharSequence)id)) {
                    clientId = id;
                    OAIDLog.print("Client id is WidevineID");
                    return;
                }
                id = DeviceID.getAndroidID((Context)application);
                if (!TextUtils.isEmpty((CharSequence)id)) {
                    clientId = id;
                    OAIDLog.print("Client id is AndroidID");
                    return;
                }
                clientId = DeviceID.getGUID((Context)application);
                OAIDLog.print("Client id is GUID");
            }
        });
    }

    @NonNull
    public static String getClientId() {
        return clientId == null ? "" : clientId;
    }

    @NonNull
    public static String getClientIdMD5() {
        return DeviceID.calculateHash(DeviceID.getClientId(), "MD5");
    }

    @NonNull
    public static String getClientIdSHA1() {
        return DeviceID.calculateHash(DeviceID.getClientId(), "SHA-1");
    }

    @NonNull
    public static String getOAID() {
        return oaid == null ? "" : oaid;
    }

    public static void getOAID(@NonNull Context context, @NonNull IGetter getter) {
        OAIDFactory.create(context).doGet(getter);
    }

    public static boolean supportedOAID(@NonNull Context context) {
        return OAIDFactory.create(context).supported();
    }

    @NonNull
    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getUniqueID(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            OAIDLog.print("IMEI/MEID not allowed on Android 10+");
            return "";
        }
        if (Build.VERSION.SDK_INT >= 23 && context.checkSelfPermission("android.permission.READ_PHONE_STATE") != 0) {
            OAIDLog.print("android.permission.READ_PHONE_STATE not granted");
            return "";
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String deviceId = tm.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String imei = tm.getImei();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                return imei;
            }
            String meid = tm.getMeid();
            if (!TextUtils.isEmpty((CharSequence)meid)) {
                return meid;
            }
        }
        return "";
    }

    @NonNull
    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID(@NonNull Context context) {
        String id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if ("9774d56d682e549c".equals(id)) {
            return "";
        }
        return id == null ? "" : id;
    }

    @Deprecated
    @NonNull
    public static String getWidevineID(@NonNull Context context) {
        return DeviceID.getWidevineID();
    }

    @NonNull
    public static String getWidevineID() {
        try {
            UUID WIDEVINE_UUID = new UUID(-1301668207276963122L, -6645017420763422227L);
            MediaDrm mediaDrm = new MediaDrm(WIDEVINE_UUID);
            byte[] widevineId = mediaDrm.getPropertyByteArray("deviceUniqueId");
            if (widevineId == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (byte aByte : widevineId) {
                sb.append(String.format("%02x", aByte));
            }
            return sb.toString();
        }
        catch (UnsupportedSchemeException e) {
            OAIDLog.print((Object)e);
            return "";
        }
    }

    @NonNull
    public static String getPseudoID() {
        StringBuilder sb = new StringBuilder();
        sb.append(Build.BOARD.length() % 10);
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append(Arrays.deepToString(Build.SUPPORTED_ABIS).length() % 10);
        } else {
            sb.append(Build.CPU_ABI.length() % 10);
        }
        sb.append(Build.DEVICE.length() % 10);
        sb.append(Build.DISPLAY.length() % 10);
        sb.append(Build.HOST.length() % 10);
        sb.append(Build.ID.length() % 10);
        sb.append(Build.MANUFACTURER.length() % 10);
        sb.append(Build.BRAND.length() % 10);
        sb.append(Build.MODEL.length() % 10);
        sb.append(Build.PRODUCT.length() % 10);
        sb.append(Build.BOOTLOADER.length() % 10);
        sb.append(Build.HARDWARE.length() % 10);
        sb.append(Build.TAGS.length() % 10);
        sb.append(Build.TYPE.length() % 10);
        sb.append(Build.USER.length() % 10);
        return sb.toString();
    }

    @NonNull
    public static String getGUID(@NonNull Context context) {
        String uuid = "";
        File file = null;
        if (Build.VERSION.SDK_INT < 30 && TextUtils.equals((CharSequence)Environment.getExternalStorageState(), (CharSequence)"mounted")) {
            try {
                file = new File(Environment.getExternalStorageDirectory(), "Android/.GUID_uuid");
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedReader reader = new BufferedReader(new FileReader(file));
                uuid = reader.readLine();
                reader.close();
                OAIDLog.print("Get uuid from sdcard: " + uuid);
                if (!TextUtils.isEmpty((CharSequence)uuid)) {
                    return uuid;
                }
            }
            catch (Throwable e) {
                OAIDLog.print(e);
            }
        }
        uuid = Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"GUID_uuid");
        OAIDLog.print("Get uuid from settings: " + uuid);
        if (!TextUtils.isEmpty((CharSequence)uuid)) {
            return uuid;
        }
        SharedPreferences preferences = context.getSharedPreferences("GUID", 0);
        uuid = preferences.getString("uuid", "");
        OAIDLog.print("Get uuid from preferences: " + uuid);
        if (!TextUtils.isEmpty((CharSequence)uuid)) {
            return uuid;
        }
        uuid = UUID.randomUUID().toString();
        OAIDLog.print("Get uuid from random: " + uuid);
        preferences.edit().putString("uuid", uuid).apply();
        if (file != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(uuid);
                writer.close();
            }
            catch (Throwable e) {
                OAIDLog.print(e);
            }
        }
        if (Settings.System.canWrite((Context)context)) {
            try {
                Settings.Global.putString((ContentResolver)context.getContentResolver(), (String)"GUID_uuid", (String)uuid);
            }
            catch (Throwable e) {
                OAIDLog.print(e);
            }
        } else {
            OAIDLog.print("android.permission.WRITE_SETTINGS not granted");
        }
        return uuid;
    }

    @NonNull
    public static String calculateHash(String str, String algorithm) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        try {
            byte[] data = str.getBytes();
            byte[] bytes = MessageDigest.getInstance(algorithm).digest(data);
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(String.format("%02x", aByte));
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return "";
        }
    }
}

