/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAIDGetter;
import com.samsung.android.deviceidservice.IDeviceIdService;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SamsungDeviceIdImpl
implements IDeviceId {
    private Context context;

    public SamsungDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.samsung.android.deviceidservice", 0);
            return pi != null;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IOAIDGetter getter) {
        Intent intent = new Intent();
        intent.setClassName("com.samsung.android.deviceidservice", "com.samsung.android.deviceidservice.DeviceIdService");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Logger.print((Object)"Samsung DeviceIdService connected");
                    try {
                        Method asInterface = IDeviceIdService.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                        IDeviceIdService anInterface = (IDeviceIdService)asInterface.invoke(null, service);
                        if (anInterface == null) {
                            throw new RuntimeException("IDeviceIdService is null");
                        }
                        String deviceId = anInterface.getID();
                        if (deviceId == null || deviceId.length() == 0) {
                            throw new RuntimeException("Samsung DeviceId get failed");
                        }
                        getter.onOAIDGetComplete(deviceId);
                    }
                    catch (Exception e) {
                        Logger.print((Object)e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        SamsungDeviceIdImpl.this.context.unbindService((ServiceConnection)this);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    Logger.print((Object)"Samsung DeviceIdService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("Samsung DeviceIdService bind failed");
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        this.doGet(new IOAIDGetter(){

            @Override
            public void onOAIDGetComplete(@NonNull String oaid) {
                getter.onDeviceIdGetComplete(oaid);
            }

            @Override
            public void onOAIDGetError(@NonNull Exception exception) {
                getter.onDeviceIdGetError(exception);
            }
        });
    }
}

