/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAIDGetter;
import java.util.Objects;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MeizuDeviceIdImpl
implements IDeviceId {
    private Context context;

    public MeizuDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            ProviderInfo pi = this.context.getPackageManager().resolveContentProvider("com.meizu.flyme.openidsdk", 0);
            if (pi != null) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.print((Object)e);
        }
        return false;
    }

    @Override
    public void doGet(@NonNull IOAIDGetter getter) {
        Uri uri = Uri.parse((String)"content://com.meizu.flyme.openidsdk/");
        try (Cursor cursor = this.context.getContentResolver().query(uri, null, null, new String[]{"oaid"}, null);){
            Objects.requireNonNull(cursor).moveToFirst();
            String ret = null;
            int valueIdx = cursor.getColumnIndex("value");
            if (valueIdx > 0) {
                ret = cursor.getString(valueIdx);
            }
            if (ret == null || ret.length() == 0) {
                throw new RuntimeException("OAID query failed");
            }
            getter.onOAIDGetComplete(ret);
        }
        catch (Exception e) {
            Logger.print((Object)e);
            getter.onOAIDGetError(e);
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        this.doGet(new IOAIDGetter(){

            @Override
            public void onOAIDGetComplete(@NonNull String oaid) {
                getter.onDeviceIdGetComplete(oaid);
            }

            @Override
            public void onOAIDGetError(@NonNull Exception exception) {
                getter.onDeviceIdGetError(exception);
            }
        });
    }
}

