/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAIDGetter;
import com.uodis.opendevice.aidl.OpenDeviceIdentifierService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class HuaweiDeviceIdImpl
implements IDeviceId {
    private Context context;

    public HuaweiDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.huawei.hwid", 0);
            return pi != null;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IOAIDGetter getter) {
        Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        intent.setPackage("com.huawei.hwid");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Logger.print((Object)"Huawei OPENIDS_SERVICE connected");
                    try {
                        OpenDeviceIdentifierService anInterface = OpenDeviceIdentifierService.Stub.asInterface(service);
                        String IDs = anInterface.getIDs();
                        if (IDs == null || IDs.length() == 0) {
                            throw new RuntimeException("Huawei IDs get failed");
                        }
                        getter.onOAIDGetComplete(IDs);
                    }
                    catch (Exception e) {
                        Logger.print((Object)e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        HuaweiDeviceIdImpl.this.context.unbindService((ServiceConnection)this);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    Logger.print((Object)"Huawei OPENIDS_SERVICE disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("Huawei OPENIDS_SERVICE bind failed");
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        this.doGet(new IOAIDGetter(){

            @Override
            public void onOAIDGetComplete(@NonNull String oaid) {
                getter.onDeviceIdGetComplete(oaid);
            }

            @Override
            public void onOAIDGetError(@NonNull Exception exception) {
                getter.onDeviceIdGetError(exception);
            }
        });
    }
}

