/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ContentProviderClient;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NubiaDeviceIdImpl
implements IDeviceId {
    private Context context;

    public NubiaDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        return false;
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        String oaid = null;
        Bundle bundle = null;
        try {
            Uri uri = Uri.parse((String)"content://cn.nubia.identity/identity");
            if (Build.VERSION.SDK_INT > 17) {
                ContentProviderClient client = this.context.getContentResolver().acquireContentProviderClient(uri);
                if (client != null) {
                    bundle = client.call("getOAID", null, null);
                    if (Build.VERSION.SDK_INT >= 24) {
                        client.close();
                    } else {
                        client.release();
                    }
                }
            } else {
                bundle = this.context.getContentResolver().call(uri, "getOAID", null, null);
            }
            if (bundle == null) {
                getter.onDeviceIdGetError(new RuntimeException("getOAID call failed"));
                return;
            }
            if (bundle.getInt("code", -1) == 0) {
                oaid = bundle.getString("id");
            }
            String failedMsg = bundle.getString("message");
            if (oaid != null && oaid.length() > 0) {
                getter.onDeviceIdGetComplete(oaid);
            } else {
                getter.onDeviceIdGetError(new RuntimeException(failedMsg));
            }
        }
        catch (Exception e) {
            Logger.print((Object)e);
            getter.onDeviceIdGetError(e);
        }
    }
}

