/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid;

import android.content.Context;
import android.os.Build;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.SystemUtils;
import com.github.gzuliyujiang.oaid.impl.AsusDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.DefaultDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.HuaweiDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.LenovoDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.MeizuDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.MsaDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.NubiaDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.OppoDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.SamsungDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.VivoDeviceIdImpl;
import com.github.gzuliyujiang.oaid.impl.XiaomiDeviceIdImpl;

public final class DeviceID {
    private DeviceID() {
    }

    public static IDeviceId with(Context context) {
        IDeviceId deviceId = SystemUtils.isLenovo() || SystemUtils.isMotolora() ? new LenovoDeviceIdImpl(context) : (SystemUtils.isMeizu() ? new MeizuDeviceIdImpl(context) : (SystemUtils.isNubia() ? new NubiaDeviceIdImpl(context) : (SystemUtils.isXiaomi() || SystemUtils.isBlackShark() ? new XiaomiDeviceIdImpl(context) : (SystemUtils.isSamsung() ? new SamsungDeviceIdImpl(context) : (SystemUtils.isVivo() ? new VivoDeviceIdImpl(context) : (SystemUtils.isASUS() ? new AsusDeviceIdImpl(context) : (SystemUtils.isHuawei() ? new HuaweiDeviceIdImpl(context) : (SystemUtils.isOppo() || SystemUtils.isOnePlus() ? new OppoDeviceIdImpl(context) : (SystemUtils.isZTE() || SystemUtils.isFreeme() || SystemUtils.isSSUI() ? new MsaDeviceIdImpl(context) : new DefaultDeviceIdImpl())))))))));
        Logger.print((Object)(DeviceID.deviceInfo() + "\nsupportOAID: " + deviceId.supportOAID()));
        return deviceId;
    }

    public static String deviceInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("BrandModel\uff1a");
        sb.append(Build.BRAND);
        sb.append(" ");
        sb.append(Build.MODEL);
        sb.append("\n");
        sb.append("Manufacturer\uff1a");
        sb.append(Build.MANUFACTURER);
        sb.append("\n");
        sb.append("SystemVersion\uff1a");
        sb.append(Build.VERSION.RELEASE);
        sb.append(" (API ");
        sb.append(Build.VERSION.SDK_INT);
        sb.append(")");
        return sb.toString();
    }
}

