/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class XiaomiDeviceIdImpl
implements IDeviceId {
    private Context context;
    private Class idProvider;

    public XiaomiDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    @SuppressLint(value={"PrivateApi"})
    public boolean supportOAID() {
        try {
            this.idProvider = Class.forName("com.android.id.impl.IdProviderImpl");
            return true;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    @SuppressLint(value={"PrivateApi"})
    public void doGet(@NonNull IGetter getter) {
        if (this.idProvider == null) {
            try {
                this.idProvider = Class.forName("com.android.id.impl.IdProviderImpl");
            }
            catch (Exception e) {
                Logger.print((Object)e);
            }
        }
        String did = null;
        try {
            Method udidMethod = this.idProvider.getMethod("getDefaultUDID", Context.class);
            did = this.invokeMethod(udidMethod);
        }
        catch (Exception e) {
            Logger.print((Object)e);
        }
        if (did != null && did.length() > 0) {
            getter.onDeviceIdGetComplete(did);
            return;
        }
        try {
            Method oaidMethod = this.idProvider.getMethod("getOAID", Context.class);
            did = this.invokeMethod(oaidMethod);
            if (did != null && did.length() > 0) {
                getter.onDeviceIdGetComplete(did);
            } else {
                getter.onDeviceIdGetError(new RuntimeException("Xiaomi OAID get failed"));
            }
        }
        catch (Exception e) {
            Logger.print((Object)e);
            getter.onDeviceIdGetError(e);
        }
    }

    private String invokeMethod(Method method) {
        String result = null;
        if (method != null) {
            try {
                result = (String)method.invoke(this.idProvider.newInstance(), this.context);
            }
            catch (Exception e) {
                Logger.print((Object)e);
            }
        }
        return result;
    }
}

