/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.Utils;
import java.util.Objects;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class VivoDeviceIdImpl
implements IDeviceId {
    private Context context;

    public VivoDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        return Utils.sysProperty("persist.sys.identifierid.supported", "0").equals("1");
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        Uri uri = Uri.parse((String)"content://com.vivo.vms.IdProvider/IdentifierId/OAID");
        try (Cursor cursor = this.context.getContentResolver().query(uri, null, null, null, null);){
            Objects.requireNonNull(cursor).moveToFirst();
            String ret = cursor.getString(cursor.getColumnIndex("value"));
            if (ret != null && ret.length() > 0) {
                Logger.print((Object)("oaid from provider: " + uri));
                getter.onDeviceIdGetComplete(ret);
            } else {
                getter.onDeviceIdGetError(new RuntimeException("OAID query failed"));
            }
        }
        catch (Exception e) {
            Logger.print((Object)e);
            getter.onDeviceIdGetError(e);
        }
    }
}

