/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import com.heytap.openid.IOpenID;
import java.lang.reflect.Method;
import java.security.MessageDigest;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class OppoDeviceIdImpl
implements IDeviceId {
    private Context context;
    private String sign;

    public OppoDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.heytap.openid", 0);
            return pi != null;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent("action.com.heytap.openid.OPEN_ID_SERVICE");
        intent.setComponent(new ComponentName("com.heytap.openid", "com.heytap.openid.IdentifyService"));
        boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                Logger.print((Object)"HeyTap IdentifyService connected");
                try {
                    String ouid = OppoDeviceIdImpl.this.realGetOUID(service);
                    if (ouid == null || ouid.length() == 0) {
                        getter.onDeviceIdGetError(new RuntimeException("HeyTap OUID get failed"));
                    } else {
                        getter.onDeviceIdGetComplete(ouid);
                    }
                }
                catch (Exception e) {
                    Logger.print((Object)e);
                    getter.onDeviceIdGetError(e);
                }
                finally {
                    OppoDeviceIdImpl.this.context.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.print((Object)"HeyTap IdentifyService disconnected");
            }
        }, 1);
        if (!isBinded) {
            getter.onDeviceIdGetError(new RuntimeException("HeyTap IdentifyService bind failed"));
        }
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private String realGetOUID(IBinder service) {
        String pkgName = this.context.getPackageName();
        if (this.sign == null) {
            try {
                Signature[] signatures = this.context.getPackageManager().getPackageInfo((String)pkgName, (int)64).signatures;
                byte[] byteArray = signatures[0].toByteArray();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                if (messageDigest != null) {
                    byte[] digest = messageDigest.digest(byteArray);
                    StringBuilder sb = new StringBuilder();
                    for (byte b : digest) {
                        sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
                    }
                    this.sign = sb.toString();
                }
                Method asInterface = IOpenID.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                IOpenID anInterface = (IOpenID)asInterface.invoke(null, service);
                return anInterface.getSerID(pkgName, this.sign, "OUID");
            }
            catch (Exception e) {
                Logger.print((Object)e);
            }
        }
        return null;
    }
}

