/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.bun.lib.MsaIdInterface;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MsaDeviceIdImpl
implements IDeviceId {
    private Context context;

    public MsaDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.mdid.msa", 0);
            return pi != null;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent;
        try {
            intent = new Intent("com.bun.msa.action.start.service");
            intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaKlService");
            intent.putExtra("com.bun.msa.param.pkgname", this.context.getPackageName());
            intent.putExtra("com.bun.msa.param.runinset", true);
            this.context.startService(intent);
        }
        catch (Exception e) {
            Logger.print((Object)e);
        }
        intent = new Intent("com.bun.msa.action.bindto.service");
        intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaIdService");
        intent.putExtra("com.bun.msa.param.pkgname", this.context.getPackageName());
        boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                Logger.print((Object)"MsaIdService connected");
                try {
                    Method asInterface = MsaIdInterface.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                    MsaIdInterface anInterface = (MsaIdInterface)asInterface.invoke(null, service);
                    String oaid = anInterface.getOAID();
                    if (oaid == null || oaid.length() == 0) {
                        getter.onDeviceIdGetError(new RuntimeException("Msa oaid get failed"));
                    } else {
                        getter.onDeviceIdGetComplete(oaid);
                    }
                }
                catch (Exception e) {
                    Logger.print((Object)e);
                    getter.onDeviceIdGetError(e);
                }
                finally {
                    MsaDeviceIdImpl.this.context.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.print((Object)"MsaIdService disconnected");
            }
        }, 1);
        if (!isBinded) {
            getter.onDeviceIdGetError(new RuntimeException("MsaIdService bind failed"));
        }
    }
}

