/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import com.zui.deviceidservice.IDeviceidInterface;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LenovoDeviceIdImpl
implements IDeviceId {
    private Context context;

    public LenovoDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.zui.deviceidservice", 0);
            return pi != null;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent();
        intent.setClassName("com.zui.deviceidservice", "com.zui.deviceidservice.DeviceidService");
        boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                Logger.print((Object)"Lenovo DeviceidService connected");
                try {
                    Method asInterface = IDeviceidInterface.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                    IDeviceidInterface anInterface = (IDeviceidInterface)asInterface.invoke(null, service);
                    String deviceId = anInterface.a();
                    if (deviceId == null || deviceId.length() == 0) {
                        getter.onDeviceIdGetError(new RuntimeException("Lenovo deviceId get failed"));
                    } else {
                        getter.onDeviceIdGetComplete(deviceId);
                    }
                }
                catch (Exception e) {
                    Logger.print((Object)e);
                    getter.onDeviceIdGetError(e);
                }
                finally {
                    LenovoDeviceIdImpl.this.context.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.print((Object)"Lenovo DeviceidService disconnected");
            }
        }, 1);
        if (!isBinded) {
            getter.onDeviceIdGetError(new RuntimeException("Lenovo DeviceidService bind failed"));
        }
    }
}

