/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import java.util.concurrent.Executors;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DefaultDeviceIdImpl
implements IDeviceId {
    private Context context;

    public DefaultDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        return false;
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        String guid = this.readGuid();
        if (TextUtils.isEmpty((CharSequence)guid)) {
            guid = UUID.randomUUID().toString();
            Logger.print((Object)("generate guid: " + guid));
            getter.onDeviceIdGetComplete(guid);
            String finalGuid = guid;
            Executors.newSingleThreadExecutor().execute(() -> {
                this.writeToSharedPreferences(finalGuid);
                this.writeToExternalStorage(finalGuid);
            });
        } else {
            getter.onDeviceIdGetComplete(guid);
        }
    }

    private String readGuid() {
        String guid = this.readFromSharedPreferences();
        if (guid != null) {
            Logger.print((Object)("read guid from SharedPreferences: " + guid));
            return guid;
        }
        guid = this.readFromExternalStorage();
        if (guid != null) {
            Logger.print((Object)("read guid from ExternalStoragePublicDirectory: " + guid));
            this.writeToSharedPreferences(guid);
            return guid;
        }
        return null;
    }

    private String readFromSharedPreferences() {
        SharedPreferences sp = this.context.getSharedPreferences(".OAID", 0);
        return sp.getString("l__y__j", null);
    }

    private void writeToSharedPreferences(String guid) {
        Logger.print((Object)("write guid to SharedPreferences: " + guid));
        SharedPreferences sp = this.context.getSharedPreferences(".OAID", 0);
        sp.edit().putString("l__y__j", guid).apply();
    }

    private String readFromExternalStorage() {
        String result = null;
        try {
            FileInputStream stream;
            BufferedReader reader;
            String line;
            File file = new File(Environment.getExternalStoragePublicDirectory((String)"Android"), ".OAID");
            if (file.isDirectory() || !file.isFile()) {
                Logger.print((Object)"The OAID file doesn't not exist.");
                return null;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            if ((line = (reader = new BufferedReader(new InputStreamReader(stream = new FileInputStream(file)))).readLine()) != null) {
                result = line;
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            Logger.print((Object)e);
        }
        return result;
    }

    private void writeToExternalStorage(String guid) {
        Logger.print((Object)("write guid to ExternalStoragePublicDirectory: " + guid));
        try {
            File file = new File(Environment.getExternalStoragePublicDirectory((String)"Android"), ".OAID");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(guid.getBytes());
            fos.close();
        }
        catch (Exception e) {
            Logger.print((Object)e);
        }
    }
}

