/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.asus.msa.SupplementaryDID.IDidAidlInterface;
import com.github.gzuliyujiang.logger.Logger;
import com.github.gzuliyujiang.oaid.IDeviceId;
import com.github.gzuliyujiang.oaid.IGetter;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AsusDeviceIdImpl
implements IDeviceId {
    private Context context;

    public AsusDeviceIdImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.asus.msa.SupplementaryDID", 0);
            return pi != null;
        }
        catch (Exception e) {
            Logger.print((Object)e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent("com.asus.msa.action.ACCESS_DID");
        ComponentName componentName = new ComponentName("com.asus.msa.SupplementaryDID", "com.asus.msa.SupplementaryDID.SupplementaryDIDService");
        intent.setComponent(componentName);
        boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                Logger.print((Object)"ASUS SupplementaryDIDService connected");
                try {
                    Method asInterface = IDidAidlInterface.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
                    IDidAidlInterface anInterface = (IDidAidlInterface)asInterface.invoke(null, service);
                    String ID = anInterface.getID();
                    if (ID == null || ID.length() == 0) {
                        getter.onDeviceIdGetError(new RuntimeException("ASUS ID get failed"));
                    } else {
                        getter.onDeviceIdGetComplete(ID);
                    }
                }
                catch (Exception e) {
                    Logger.print((Object)e);
                    getter.onDeviceIdGetError(e);
                }
                finally {
                    AsusDeviceIdImpl.this.context.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.print((Object)"ASUS SupplementaryDIDService disconnected");
            }
        }, 1);
        if (!isBinded) {
            getter.onDeviceIdGetError(new RuntimeException("ASUS SupplementaryDIDService bind failed"));
        }
    }
}

