/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelview.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.wheelview.R;
import com.github.gzuliyujiang.wheelview.contract.OnWheelChangedListener;
import com.github.gzuliyujiang.wheelview.contract.TextProvider;
import com.github.gzuliyujiang.wheelview.contract.WheelFormatter;
import java.util.ArrayList;
import java.util.List;

public class WheelView
extends View
implements Runnable {
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;
    protected List<?> data = new ArrayList();
    protected WheelFormatter formatter;
    protected Object defaultItem;
    protected int visibleItemCount;
    protected int defaultItemPosition;
    protected int currentPosition;
    protected String maxWidthText;
    protected int textColor;
    protected int textColorSelected;
    protected int textSize;
    protected float indicatorSize;
    protected int indicatorColor;
    protected int curtainColor;
    protected int itemSpace;
    protected int textAlign;
    protected boolean sameWidthEnabled;
    protected boolean indicatorEnabled;
    protected boolean curtainEnabled;
    protected boolean atmosphericEnabled;
    protected boolean cyclicEnabled;
    protected boolean curvedEnabled;
    protected int curvedMaxAngle = 90;
    protected int curvedIndicatorSpace;
    private final Handler handler = new Handler();
    private final Paint paint = new Paint(69);
    private final Scroller scroller;
    private VelocityTracker tracker;
    private OnWheelChangedListener onWheelChangedListener;
    private final Rect rectDrawn = new Rect();
    private final Rect rectIndicatorHead = new Rect();
    private final Rect rectIndicatorFoot = new Rect();
    private final Rect rectCurrentItem = new Rect();
    private final Camera camera = new Camera();
    private final Matrix matrixRotate = new Matrix();
    private final Matrix matrixDepth = new Matrix();
    private int lastScrollPosition;
    private int drawnItemCount;
    private int halfDrawnItemCount;
    private int textMaxWidth;
    private int textMaxHeight;
    private int itemHeight;
    private int halfItemHeight;
    private int halfWheelHeight;
    private int minFlingYCoordinate;
    private int maxFlingYCoordinate;
    private int wheelCenterXCoordinate;
    private int wheelCenterYCoordinate;
    private int drawnCenterXCoordinate;
    private int drawnCenterYCoordinate;
    private int scrollOffsetYCoordinate;
    private int lastPointYCoordinate;
    private int downPointYCoordinate;
    private final int minimumVelocity;
    private final int maximumVelocity;
    private final int touchSlop;
    private boolean isClick;
    private boolean isForceFinishScroll;
    private final AttributeSet attrs;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.WheelStyle);
    }

    public WheelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attrs = attrs;
        this.initAttrs(context, attrs, defStyleAttr, R.style.WheelDefault);
        this.updateVisibleItemCount();
        this.paint.setTextSize((float)this.textSize);
        this.scroller = new Scroller(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.minimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.touchSlop = configuration.getScaledTouchSlop();
        if (this.isInEditMode()) {
            this.setData(this.generatePreviewData());
        }
    }

    public void setStyle(@StyleRes int style2) {
        if (this.attrs == null) {
            throw new RuntimeException("Please use " + this.getClass().getSimpleName() + " in xml");
        }
        this.initAttrs(this.getContext(), this.attrs, R.attr.WheelStyle, style2);
        this.requestLayout();
        this.invalidate();
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs == null) {
            float density = context.getResources().getDisplayMetrics().density;
            float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
            this.textSize = (int)(15.0f * scaledDensity);
            this.visibleItemCount = 5;
            this.defaultItemPosition = 0;
            this.sameWidthEnabled = false;
            this.maxWidthText = "";
            this.textColorSelected = -16777216;
            this.textColor = -7829368;
            this.itemSpace = (int)(20.0f * density);
            this.cyclicEnabled = false;
            this.indicatorEnabled = true;
            this.indicatorColor = -3552823;
            this.indicatorSize = 1.0f * density;
            this.curvedIndicatorSpace = (int)(1.0f * density);
            this.curtainEnabled = false;
            this.curtainColor = -1;
            this.atmosphericEnabled = false;
            this.curvedEnabled = false;
            this.curvedMaxAngle = 90;
            this.textAlign = 0;
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WheelView, defStyleAttr, defStyleRes);
        this.onAttributeSet(context, typedArray);
        typedArray.recycle();
    }

    protected void onAttributeSet(@NonNull Context context, @NonNull TypedArray typedArray) {
        float density = context.getResources().getDisplayMetrics().density;
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.WheelView_wheel_itemTextSize, (int)(15.0f * scaledDensity));
        this.visibleItemCount = typedArray.getInt(R.styleable.WheelView_wheel_visibleItemCount, 5);
        this.sameWidthEnabled = typedArray.getBoolean(R.styleable.WheelView_wheel_sameWidthEnabled, false);
        this.maxWidthText = typedArray.getString(R.styleable.WheelView_wheel_maxWidthText);
        this.textColorSelected = typedArray.getColor(R.styleable.WheelView_wheel_itemTextColorSelected, -16777216);
        this.textColor = typedArray.getColor(R.styleable.WheelView_wheel_itemTextColor, -7829368);
        this.itemSpace = typedArray.getDimensionPixelSize(R.styleable.WheelView_wheel_itemSpace, (int)(20.0f * density));
        this.cyclicEnabled = typedArray.getBoolean(R.styleable.WheelView_wheel_cyclicEnabled, false);
        this.indicatorEnabled = typedArray.getBoolean(R.styleable.WheelView_wheel_indicatorEnabled, true);
        this.indicatorColor = typedArray.getColor(R.styleable.WheelView_wheel_indicatorColor, -3552823);
        this.indicatorSize = typedArray.getDimension(R.styleable.WheelView_wheel_indicatorSize, 1.0f * density);
        this.curvedIndicatorSpace = typedArray.getDimensionPixelSize(R.styleable.WheelView_wheel_curvedIndicatorSpace, (int)(1.0f * density));
        this.curtainEnabled = typedArray.getBoolean(R.styleable.WheelView_wheel_curtainEnabled, false);
        this.curtainColor = typedArray.getColor(R.styleable.WheelView_wheel_curtainColor, -1);
        this.atmosphericEnabled = typedArray.getBoolean(R.styleable.WheelView_wheel_atmosphericEnabled, false);
        this.curvedEnabled = typedArray.getBoolean(R.styleable.WheelView_wheel_curvedEnabled, false);
        this.curvedMaxAngle = typedArray.getInteger(R.styleable.WheelView_wheel_curvedMaxAngle, 90);
        this.textAlign = typedArray.getInt(R.styleable.WheelView_wheel_itemTextAlign, 0);
    }

    protected List<?> generatePreviewData() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("\u8d35\u5dde\u7a7f\u9752\u4eba");
        data.add("\u5927\u5b9a\u5e9c\u7fa1\u6c11");
        data.add("\u4e0d\u5728\u4e94\u5341\u516d\u4e2a\u6c11\u65cf\u4e4b\u5185");
        data.add("\u5df2\u8bc6\u522b\u5f85\u5b9a\u6c11\u65cf");
        data.add("\u7a7f\u9752\u5c71\u9b48\u4eba\u9a6c");
        data.add("\u674e\u88d5\u6c5f");
        return data;
    }

    private void updateVisibleItemCount() {
        int minCount = 2;
        if (this.visibleItemCount < 2) {
            throw new ArithmeticException("Visible item count can not be less than 2");
        }
        int evenNumberFlag = 2;
        if (this.visibleItemCount % evenNumberFlag == 0) {
            ++this.visibleItemCount;
        }
        this.drawnItemCount = this.visibleItemCount + 2;
        this.halfDrawnItemCount = this.drawnItemCount / 2;
    }

    private void computeTextWidthAndHeight() {
        this.textMaxHeight = 0;
        this.textMaxWidth = 0;
        if (this.sameWidthEnabled) {
            this.textMaxWidth = (int)this.paint.measureText(this.formatItem(0));
        } else if (!TextUtils.isEmpty((CharSequence)this.maxWidthText)) {
            this.textMaxWidth = (int)this.paint.measureText(this.maxWidthText);
        } else {
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                int width = (int)this.paint.measureText(this.formatItem(i));
                this.textMaxWidth = Math.max(this.textMaxWidth, width);
            }
        }
        Paint.FontMetrics metrics = this.paint.getFontMetrics();
        this.textMaxHeight = (int)(metrics.bottom - metrics.top);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public Object getItem(int position) {
        int size = this.data.size();
        if (size == 0) {
            return null;
        }
        int index = (position + size) % size;
        if (index >= 0 && index <= size - 1) {
            return this.data.get(index);
        }
        return null;
    }

    public int getPosition(Object item) {
        if (item == null) {
            return 0;
        }
        return this.data.indexOf(item);
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public Object getCurrentItem() {
        return this.getItem(this.currentPosition);
    }

    public int getVisibleItemCount() {
        return this.visibleItemCount;
    }

    public void setVisibleItemCount(@IntRange(from=2L) int count) {
        this.visibleItemCount = count;
        this.updateVisibleItemCount();
        this.requestLayout();
    }

    public boolean isCyclicEnabled() {
        return this.cyclicEnabled;
    }

    public void setCyclicEnabled(boolean isCyclic) {
        this.cyclicEnabled = isCyclic;
        this.computeFlingLimitYCoordinate();
        this.invalidate();
    }

    public void setOnWheelChangedListener(OnWheelChangedListener listener) {
        this.onWheelChangedListener = listener;
    }

    public void setFormatter(WheelFormatter formatter) {
        this.formatter = formatter;
    }

    public List<?> getData() {
        return this.data;
    }

    public void setData(List<?> newData) {
        if (newData == null) {
            newData = new ArrayList();
        }
        this.data = newData;
        this.notifyDataSetChanged();
    }

    public void setDefaultValue(Object value) {
        if (value == null) {
            return;
        }
        boolean found = false;
        int position = 0;
        for (Object item : this.data) {
            String text;
            if (item.equals(value)) {
                found = true;
                break;
            }
            if (this.formatter != null && this.formatter.formatItem(item).equals(this.formatter.formatItem(value))) {
                found = true;
                break;
            }
            if (item instanceof TextProvider && (text = ((TextProvider)item).provideText()).equals(value)) {
                found = true;
                break;
            }
            ++position;
        }
        if (!found) {
            position = 0;
        }
        this.setDefaultPosition(position);
    }

    public void setDefaultPosition(int position) {
        position = Math.min(position, this.getItemCount() - 1);
        position = Math.max(position, 0);
        this.defaultItem = this.getItem(position);
        this.defaultItemPosition = position;
        this.currentPosition = position;
        this.scrollOffsetYCoordinate = 0;
        this.computeFlingLimitYCoordinate();
        this.requestLayout();
        this.invalidate();
    }

    public boolean isSameWidthEnabled() {
        return this.sameWidthEnabled;
    }

    public void setSameWidthEnabled(boolean sameWidthEnabled) {
        this.sameWidthEnabled = sameWidthEnabled;
        this.computeTextWidthAndHeight();
        this.requestLayout();
        this.invalidate();
    }

    public String getMaxWidthText() {
        return this.maxWidthText;
    }

    public void setMaxWidthText(String text) {
        if (null == text) {
            throw new NullPointerException("Maximum width text can not be null!");
        }
        this.maxWidthText = text;
        this.computeTextWidthAndHeight();
        this.requestLayout();
        this.invalidate();
    }

    @ColorInt
    public int getSelectedTextColor() {
        return this.textColorSelected;
    }

    public void setSelectedTextColor(@ColorInt int color) {
        this.textColorSelected = color;
        this.computeCurrentItemRect();
        this.invalidate();
    }

    @ColorInt
    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@ColorInt int color) {
        this.textColor = color;
        this.invalidate();
    }

    @Px
    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(@Px int size) {
        this.textSize = size;
        this.paint.setTextSize((float)this.textSize);
        this.computeTextWidthAndHeight();
        this.requestLayout();
        this.invalidate();
    }

    @Px
    public int getItemSpace() {
        return this.itemSpace;
    }

    public void setItemSpace(@Px int space) {
        this.itemSpace = space;
        this.requestLayout();
        this.invalidate();
    }

    public boolean isIndicatorEnabled() {
        return this.indicatorEnabled;
    }

    public void setIndicatorEnabled(boolean indicatorEnabled) {
        this.indicatorEnabled = indicatorEnabled;
        this.computeIndicatorRect();
        this.invalidate();
    }

    @Px
    public float getIndicatorSize() {
        return this.indicatorSize;
    }

    public void setIndicatorSize(@Px float size) {
        this.indicatorSize = size;
        this.computeIndicatorRect();
        this.invalidate();
    }

    @ColorInt
    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorColor(@ColorInt int color) {
        this.indicatorColor = color;
        this.invalidate();
    }

    @Px
    public int getCurvedIndicatorSpace() {
        return this.curvedIndicatorSpace;
    }

    public void setCurvedIndicatorSpace(@Px int space) {
        this.curvedIndicatorSpace = space;
        this.computeIndicatorRect();
        this.invalidate();
    }

    public boolean isCurtainEnabled() {
        return this.curtainEnabled;
    }

    public void setCurtainEnabled(boolean curtainEnabled) {
        this.curtainEnabled = curtainEnabled;
        this.computeCurrentItemRect();
        this.invalidate();
    }

    @ColorInt
    public int getCurtainColor() {
        return this.curtainColor;
    }

    public void setCurtainColor(@ColorInt int color) {
        this.curtainColor = color;
        this.invalidate();
    }

    public boolean isAtmosphericEnabled() {
        return this.atmosphericEnabled;
    }

    public void setAtmosphericEnabled(boolean atmosphericEnabled) {
        this.atmosphericEnabled = atmosphericEnabled;
        this.invalidate();
    }

    public boolean isCurvedEnabled() {
        return this.curvedEnabled;
    }

    public void setCurvedEnabled(boolean isCurved) {
        this.curvedEnabled = isCurved;
        this.requestLayout();
        this.invalidate();
    }

    public int getCurvedMaxAngle() {
        return this.curvedMaxAngle;
    }

    public void setCurvedMaxAngle(int curvedMaxAngle) {
        this.curvedMaxAngle = curvedMaxAngle;
        this.requestLayout();
        this.invalidate();
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int align) {
        this.textAlign = align;
        this.updatePaintTextAlign();
        this.computeDrawnCenterCoordinate();
        this.invalidate();
    }

    private void updatePaintTextAlign() {
        switch (this.textAlign) {
            case 1: {
                this.paint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.paint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.paint.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    public Typeface getTypeface() {
        if (null != this.paint) {
            return this.paint.getTypeface();
        }
        return null;
    }

    public void setTypeface(Typeface typeface) {
        if (this.paint == null || typeface == null) {
            return;
        }
        this.paint.setTypeface(typeface);
        this.computeTextWidthAndHeight();
        this.requestLayout();
        this.invalidate();
    }

    public void notifyDataSetChanged() {
        this.defaultItem = this.getItem(0);
        this.defaultItemPosition = 0;
        this.currentPosition = 0;
        this.scrollOffsetYCoordinate = 0;
        this.updatePaintTextAlign();
        this.computeTextWidthAndHeight();
        this.computeFlingLimitYCoordinate();
        this.requestLayout();
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int resultWidth = this.textMaxWidth;
        int resultHeight = this.textMaxHeight * this.visibleItemCount + this.itemSpace * (this.visibleItemCount - 1);
        if (this.curvedEnabled) {
            resultHeight = (int)((double)(2 * resultHeight) / Math.PI);
        }
        resultWidth += this.getPaddingLeft() + this.getPaddingRight();
        resultHeight += this.getPaddingTop() + this.getPaddingBottom();
        resultWidth = this.measureSize(modeWidth, sizeWidth, resultWidth);
        resultHeight = this.measureSize(modeHeight, sizeHeight, resultHeight);
        this.setMeasuredDimension(resultWidth, resultHeight);
    }

    private int measureSize(int mode, int sizeExpect, int sizeActual) {
        int realSize;
        if (mode == 0x40000000) {
            realSize = sizeExpect;
        } else {
            realSize = sizeActual;
            if (mode == Integer.MIN_VALUE) {
                realSize = Math.min(realSize, sizeExpect);
            }
        }
        return realSize;
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        this.rectDrawn.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        this.wheelCenterXCoordinate = this.rectDrawn.centerX();
        this.wheelCenterYCoordinate = this.rectDrawn.centerY();
        this.computeDrawnCenterCoordinate();
        this.halfWheelHeight = this.rectDrawn.height() / 2;
        this.itemHeight = this.rectDrawn.height() / this.visibleItemCount;
        this.halfItemHeight = this.itemHeight / 2;
        this.computeFlingLimitYCoordinate();
        this.computeIndicatorRect();
        this.computeCurrentItemRect();
    }

    private void computeDrawnCenterCoordinate() {
        switch (this.textAlign) {
            case 1: {
                this.drawnCenterXCoordinate = this.rectDrawn.left;
                break;
            }
            case 2: {
                this.drawnCenterXCoordinate = this.rectDrawn.right;
                break;
            }
            default: {
                this.drawnCenterXCoordinate = this.wheelCenterXCoordinate;
            }
        }
        this.drawnCenterYCoordinate = (int)((float)this.wheelCenterYCoordinate - (this.paint.ascent() + this.paint.descent()) / 2.0f);
    }

    private void computeFlingLimitYCoordinate() {
        int currentItemOffset = this.defaultItemPosition * this.itemHeight;
        this.minFlingYCoordinate = this.cyclicEnabled ? Integer.MIN_VALUE : -this.itemHeight * (this.getItemCount() - 1) + currentItemOffset;
        this.maxFlingYCoordinate = this.cyclicEnabled ? Integer.MAX_VALUE : currentItemOffset;
    }

    private void computeIndicatorRect() {
        if (!this.indicatorEnabled) {
            return;
        }
        int indicatorSpace = this.curvedEnabled ? this.curvedIndicatorSpace : 0;
        int halfIndicatorSize = (int)(this.indicatorSize / 2.0f);
        int indicatorHeadCenterYCoordinate = this.wheelCenterYCoordinate + this.halfItemHeight + indicatorSpace;
        int indicatorFootCenterYCoordinate = this.wheelCenterYCoordinate - this.halfItemHeight - indicatorSpace;
        this.rectIndicatorHead.set(this.rectDrawn.left, indicatorHeadCenterYCoordinate - halfIndicatorSize, this.rectDrawn.right, indicatorHeadCenterYCoordinate + halfIndicatorSize);
        this.rectIndicatorFoot.set(this.rectDrawn.left, indicatorFootCenterYCoordinate - halfIndicatorSize, this.rectDrawn.right, indicatorFootCenterYCoordinate + halfIndicatorSize);
    }

    private void computeCurrentItemRect() {
        if (!this.curtainEnabled && this.textColorSelected == -1) {
            return;
        }
        this.rectCurrentItem.set(this.rectDrawn.left, this.wheelCenterYCoordinate - this.halfItemHeight, this.rectDrawn.right, this.wheelCenterYCoordinate + this.halfItemHeight);
    }

    protected void onDraw(Canvas canvas) {
        if (null != this.onWheelChangedListener) {
            this.onWheelChangedListener.onWheelScrolled(this, this.scrollOffsetYCoordinate);
        }
        if (this.itemHeight - this.halfDrawnItemCount <= 0) {
            return;
        }
        this.drawAllItemText(canvas);
        this.drawCurtain(canvas);
        this.drawIndicator(canvas);
    }

    private void drawAllItemText(Canvas canvas) {
        int drawnDataStartPos = -1 * this.scrollOffsetYCoordinate / this.itemHeight - this.halfDrawnItemCount;
        int drawnDataPosition = drawnDataStartPos + this.defaultItemPosition;
        int drawnOffsetPos = -1 * this.halfDrawnItemCount;
        while (drawnDataPosition < drawnDataStartPos + this.defaultItemPosition + this.drawnItemCount) {
            this.paint.setColor(this.textColor);
            this.paint.setStyle(Paint.Style.FILL);
            int drawnItemCenterYCoordinate = this.drawnCenterYCoordinate + drawnOffsetPos * this.itemHeight + this.scrollOffsetYCoordinate % this.itemHeight;
            int centerYCoordinateAbs = Math.abs(this.drawnCenterYCoordinate - drawnItemCenterYCoordinate);
            float ratio = (float)(this.drawnCenterYCoordinate - centerYCoordinateAbs - this.rectDrawn.top) * 1.0f / (float)(this.drawnCenterYCoordinate - this.rectDrawn.top);
            float degree = this.computeDegree(drawnItemCenterYCoordinate, ratio);
            float distanceToCenter = this.computeYCoordinateAtAngle(degree);
            if (this.curvedEnabled) {
                int transXCoordinate = this.wheelCenterXCoordinate;
                switch (this.textAlign) {
                    case 1: {
                        transXCoordinate = this.rectDrawn.left;
                        break;
                    }
                    case 2: {
                        transXCoordinate = this.rectDrawn.right;
                        break;
                    }
                }
                float transYCoordinate = (float)this.wheelCenterYCoordinate - distanceToCenter;
                this.camera.save();
                this.camera.rotateX(degree);
                this.camera.getMatrix(this.matrixRotate);
                this.camera.restore();
                this.matrixRotate.preTranslate((float)(-transXCoordinate), -transYCoordinate);
                this.matrixRotate.postTranslate((float)transXCoordinate, transYCoordinate);
                this.camera.save();
                this.camera.translate(0.0f, 0.0f, (float)this.computeDepth(degree));
                this.camera.getMatrix(this.matrixDepth);
                this.camera.restore();
                this.matrixDepth.preTranslate((float)(-transXCoordinate), -transYCoordinate);
                this.matrixDepth.postTranslate((float)transXCoordinate, transYCoordinate);
                this.matrixRotate.postConcat(this.matrixDepth);
            }
            this.computeAndSetAtmospheric(centerYCoordinateAbs);
            float drawCenterYCoordinate = this.curvedEnabled ? (float)this.drawnCenterYCoordinate - distanceToCenter : (float)drawnItemCenterYCoordinate;
            String data = this.obtainItemText(drawnDataPosition);
            if (this.paint.measureText(data) - (float)this.getMeasuredWidth() > 0.0f) {
                data = data.substring(0, data.length() - 4) + "...";
            }
            this.drawItemText(canvas, data, drawCenterYCoordinate);
            ++drawnDataPosition;
            ++drawnOffsetPos;
        }
    }

    private void drawItemText(Canvas canvas, String data, float drawCenterYCoordinate) {
        if (this.textColorSelected == -1) {
            canvas.save();
            canvas.clipRect(this.rectDrawn);
            if (this.curvedEnabled) {
                canvas.concat(this.matrixRotate);
            }
            canvas.drawText(data, (float)this.drawnCenterXCoordinate, drawCenterYCoordinate, this.paint);
            canvas.restore();
            return;
        }
        canvas.save();
        if (this.curvedEnabled) {
            canvas.concat(this.matrixRotate);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            canvas.clipOutRect(this.rectCurrentItem);
        } else {
            canvas.clipRect(this.rectCurrentItem, Region.Op.DIFFERENCE);
        }
        canvas.drawText(data, (float)this.drawnCenterXCoordinate, drawCenterYCoordinate, this.paint);
        canvas.restore();
        this.paint.setColor(this.textColorSelected);
        canvas.save();
        if (this.curvedEnabled) {
            canvas.concat(this.matrixRotate);
        }
        canvas.clipRect(this.rectCurrentItem);
        canvas.drawText(data, (float)this.drawnCenterXCoordinate, drawCenterYCoordinate, this.paint);
        canvas.restore();
    }

    private float computeDegree(int drawnItemCenterYCoordinate, float ratio) {
        int unit = 0;
        if (drawnItemCenterYCoordinate > this.drawnCenterYCoordinate) {
            unit = 1;
        } else if (drawnItemCenterYCoordinate < this.drawnCenterYCoordinate) {
            unit = -1;
        }
        return this.clamp(-(1.0f - ratio) * (float)this.curvedMaxAngle * (float)unit, -this.curvedMaxAngle, this.curvedMaxAngle);
    }

    private float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    private String obtainItemText(int drawnDataPosition) {
        String data = "";
        int itemCount = this.getItemCount();
        if (this.cyclicEnabled) {
            if (itemCount != 0) {
                int actualPosition = drawnDataPosition % itemCount;
                actualPosition = actualPosition < 0 ? actualPosition + itemCount : actualPosition;
                data = this.formatItem(actualPosition);
            }
        } else if (this.isPositionInRange(drawnDataPosition, itemCount)) {
            data = this.formatItem(drawnDataPosition);
        }
        return data;
    }

    public String formatItem(int position) {
        Object item = this.getItem(position);
        if (item instanceof TextProvider) {
            return ((TextProvider)item).provideText();
        }
        if (this.formatter != null) {
            return this.formatter.formatItem(item);
        }
        return item.toString();
    }

    private void computeAndSetAtmospheric(int abs) {
        if (this.atmosphericEnabled) {
            int alpha = (int)((float)(this.drawnCenterYCoordinate - abs) * 1.0f / (float)this.drawnCenterYCoordinate * 255.0f);
            alpha = Math.max(alpha, 0);
            this.paint.setAlpha(alpha);
        }
    }

    private void drawCurtain(Canvas canvas) {
        if (this.curtainEnabled) {
            int red = Color.red((int)this.curtainColor);
            int green = Color.green((int)this.curtainColor);
            int blue = Color.blue((int)this.curtainColor);
            this.paint.setColor(Color.argb((int)128, (int)red, (int)green, (int)blue));
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.rectCurrentItem, this.paint);
        }
    }

    private void drawIndicator(Canvas canvas) {
        if (this.indicatorEnabled) {
            this.paint.setColor(this.indicatorColor);
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.rectIndicatorHead, this.paint);
            canvas.drawRect(this.rectIndicatorFoot, this.paint);
        }
    }

    private boolean isPositionInRange(int position, int itemCount) {
        return position >= 0 && position < itemCount;
    }

    private float computeYCoordinateAtAngle(float degree) {
        return this.sinDegree(degree) / this.sinDegree(this.curvedMaxAngle) * (float)this.halfWheelHeight;
    }

    private float sinDegree(float degree) {
        return (float)Math.sin(Math.toRadians(degree));
    }

    private int computeDepth(float degree) {
        return (int)((double)this.halfWheelHeight - Math.cos(Math.toRadians(degree)) * (double)this.halfWheelHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    this.handleActionDown(event);
                    break;
                }
                case 2: {
                    this.handleActionMove(event);
                    break;
                }
                case 1: {
                    this.handleActionUp(event);
                    break;
                }
                case 3: {
                    this.handleActionCancel(event);
                    break;
                }
            }
        }
        if (this.isClick) {
            this.performClick();
        }
        return true;
    }

    private void handleActionDown(MotionEvent event) {
        if (null != this.getParent()) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        this.obtainOrClearTracker();
        this.tracker.addMovement(event);
        if (!this.scroller.isFinished()) {
            this.scroller.abortAnimation();
            this.isForceFinishScroll = true;
        }
        this.downPointYCoordinate = this.lastPointYCoordinate = (int)event.getY();
    }

    private void handleActionMove(MotionEvent event) {
        float move;
        int endPoint = this.computeDistanceToEndPoint(this.scroller.getFinalY() % this.itemHeight);
        if (Math.abs((float)this.downPointYCoordinate - event.getY()) < (float)this.touchSlop && endPoint > 0) {
            this.isClick = true;
            return;
        }
        this.isClick = false;
        if (null != this.tracker) {
            this.tracker.addMovement(event);
        }
        if (null != this.onWheelChangedListener) {
            this.onWheelChangedListener.onWheelScrollStateChanged(this, 1);
        }
        if (Math.abs(move = event.getY() - (float)this.lastPointYCoordinate) < 1.0f) {
            return;
        }
        this.scrollOffsetYCoordinate = (int)((float)this.scrollOffsetYCoordinate + move);
        this.lastPointYCoordinate = (int)event.getY();
        this.invalidate();
    }

    private void handleActionUp(MotionEvent event) {
        if (null != this.getParent()) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
        if (this.isClick) {
            return;
        }
        int yVelocity = 0;
        if (null != this.tracker) {
            this.tracker.addMovement(event);
            this.tracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
            yVelocity = (int)this.tracker.getYVelocity();
        }
        this.isForceFinishScroll = false;
        if (Math.abs(yVelocity) > this.minimumVelocity) {
            this.scroller.fling(0, this.scrollOffsetYCoordinate, 0, yVelocity, 0, 0, this.minFlingYCoordinate, this.maxFlingYCoordinate);
            int endPoint = this.computeDistanceToEndPoint(this.scroller.getFinalY() % this.itemHeight);
            this.scroller.setFinalY(this.scroller.getFinalY() + endPoint);
        } else {
            int endPoint = this.computeDistanceToEndPoint(this.scrollOffsetYCoordinate % this.itemHeight);
            this.scroller.startScroll(0, this.scrollOffsetYCoordinate, 0, endPoint);
        }
        if (!this.cyclicEnabled) {
            if (this.scroller.getFinalY() > this.maxFlingYCoordinate) {
                this.scroller.setFinalY(this.maxFlingYCoordinate);
            } else if (this.scroller.getFinalY() < this.minFlingYCoordinate) {
                this.scroller.setFinalY(this.minFlingYCoordinate);
            }
        }
        this.handler.post((Runnable)this);
        this.cancelTracker();
    }

    private void handleActionCancel(MotionEvent event) {
        if (null != this.getParent()) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
        this.cancelTracker();
    }

    private void obtainOrClearTracker() {
        if (null == this.tracker) {
            this.tracker = VelocityTracker.obtain();
        } else {
            this.tracker.clear();
        }
    }

    private void cancelTracker() {
        if (null != this.tracker) {
            this.tracker.recycle();
            this.tracker = null;
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    private int computeDistanceToEndPoint(int remainder) {
        if (Math.abs(remainder) > this.halfItemHeight) {
            if (this.scrollOffsetYCoordinate < 0) {
                return -this.itemHeight - remainder;
            }
            return this.itemHeight - remainder;
        }
        return -1 * remainder;
    }

    @Override
    public void run() {
        if (this.itemHeight == 0) {
            return;
        }
        int itemCount = this.getItemCount();
        if (itemCount == 0) {
            return;
        }
        if (this.scroller.isFinished() && !this.isForceFinishScroll) {
            int position = this.computePosition(itemCount);
            this.currentPosition = position = position < 0 ? position + itemCount : position;
            if (null != this.onWheelChangedListener) {
                this.onWheelChangedListener.onWheelSelected(this, position);
                this.onWheelChangedListener.onWheelScrollStateChanged(this, 0);
            }
            this.postInvalidate();
            return;
        }
        if (this.scroller.computeScrollOffset()) {
            if (null != this.onWheelChangedListener) {
                this.onWheelChangedListener.onWheelScrollStateChanged(this, 2);
            }
            this.scrollOffsetYCoordinate = this.scroller.getCurrY();
            int position = this.computePosition(itemCount);
            if (this.lastScrollPosition != position) {
                if (position == 0 && this.lastScrollPosition == itemCount - 1 && null != this.onWheelChangedListener) {
                    this.onWheelChangedListener.onWheelLoopFinished(this);
                }
                this.lastScrollPosition = position;
            }
            this.postInvalidate();
            this.handler.postDelayed((Runnable)this, 16L);
        }
    }

    private int computePosition(int itemCount) {
        return (-1 * this.scrollOffsetYCoordinate / this.itemHeight + this.defaultItemPosition) % itemCount;
    }

    public final void scrollTo(final int position) {
        if (position == this.currentPosition) {
            return;
        }
        int differencesLines = this.currentPosition - position;
        int newScrollOffsetYCoordinate = this.scrollOffsetYCoordinate + differencesLines * this.itemHeight;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.scrollOffsetYCoordinate, newScrollOffsetYCoordinate});
        animator.setDuration(300L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                WheelView.this.scrollOffsetYCoordinate = (Integer)animation.getAnimatedValue();
                WheelView.this.invalidate();
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                WheelView.this.currentPosition = position;
            }
        });
        animator.start();
    }
}

