/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class DatePicker
extends WheelPicker {
    public static final int YEAR_MONTH_DAY = 0;
    public static final int YEAR_MONTH = 1;
    public static final int MONTH_DAY = 2;
    private ArrayList<String> years = new ArrayList();
    private ArrayList<String> months = new ArrayList();
    private ArrayList<String> days = new ArrayList();
    private OnWheelListener onWheelListener;
    private OnDatePickListener onDatePickListener;
    private String yearLabel = "\u5e74";
    private String monthLabel = "\u6708";
    private String dayLabel = "\u65e5";
    private int startYear = 2010;
    private int startMonth = 1;
    private int startDay = 1;
    private int endYear = 2020;
    private int endMonth = 12;
    private int endDay = 31;
    private int selectedYearIndex = 0;
    private int selectedMonthIndex = 0;
    private int selectedDayIndex = 0;
    private int mode = 0;

    public DatePicker(Activity activity) {
        this(activity, 0);
    }

    public DatePicker(Activity activity, int mode) {
        super(activity);
        this.mode = mode;
    }

    public void setLabel(String yearLabel, String monthLabel, String dayLabel) {
        this.yearLabel = yearLabel;
        this.monthLabel = monthLabel;
        this.dayLabel = dayLabel;
    }

    @Deprecated
    public void setRange(int startYear, int endYear) {
        this.startYear = startYear;
        this.endYear = endYear;
        this.changeYearData();
    }

    public void setRangeStart(int startYear, int startMonth, int startDay) {
        this.startYear = startYear;
        this.startMonth = startMonth;
        this.startDay = startDay;
    }

    public void setRangeEnd(int endYear, int endMonth, int endDay) {
        this.endYear = endYear;
        this.endMonth = endMonth;
        this.endDay = endDay;
    }

    public void setRangeStart(int startYearOrMonth, int startMonthOrDay) {
        if (this.mode == 0) {
            throw new IllegalArgumentException();
        }
        if (this.mode == 1) {
            this.startYear = startYearOrMonth;
            this.startMonth = startMonthOrDay;
        } else {
            int year;
            this.startYear = this.endYear = (year = Calendar.getInstance(Locale.CHINA).get(1));
            this.startMonth = startYearOrMonth;
            this.startDay = startMonthOrDay;
        }
    }

    public void setRangeEnd(int endYearOrMonth, int endMonthOrDay) {
        if (this.mode == 0) {
            throw new IllegalArgumentException();
        }
        if (this.mode == 1) {
            this.endYear = endYearOrMonth;
            this.endMonth = endMonthOrDay;
        } else {
            this.endMonth = endYearOrMonth;
            this.endDay = endMonthOrDay;
        }
    }

    public void setSelectedItem(int year, int month, int day) {
        this.changeYearData();
        this.changeMonthData(year);
        this.changeDayData(year, month);
        this.selectedYearIndex = this.findItemIndex(this.years, year);
        this.selectedMonthIndex = this.findItemIndex(this.months, month);
        this.selectedDayIndex = this.findItemIndex(this.days, day);
    }

    public void setSelectedItem(int yearOrMonth, int monthOrDay) {
        if (this.mode == 2) {
            int year;
            this.startYear = this.endYear = (year = Calendar.getInstance(Locale.CHINA).get(1));
            this.changeYearData();
            this.changeMonthData(year);
            this.changeDayData(year, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, yearOrMonth);
            this.selectedDayIndex = this.findItemIndex(this.days, monthOrDay);
        } else {
            this.changeYearData();
            this.changeMonthData(yearOrMonth);
            this.selectedYearIndex = this.findItemIndex(this.years, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, monthOrDay);
        }
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnDatePickListener(OnDatePickListener listener) {
        this.onDatePickListener = listener;
    }

    @NonNull
    protected View makeCenterView() {
        if (this.months.size() == 0) {
            int year = Calendar.getInstance(Locale.CHINA).get(1);
            this.changeYearData();
            this.changeDayData(year, this.changeMonthData(year));
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView yearView = new WheelView(this.activity.getBaseContext());
        yearView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        yearView.setTextSize(this.textSize);
        yearView.setTextColor(this.textColorNormal, this.textColorFocus);
        yearView.setLineVisible(this.lineVisible);
        yearView.setLineColor(this.lineColor);
        yearView.setOffset(this.offset);
        yearView.setCycleDisable(this.cycleDisable);
        layout.addView((View)yearView);
        TextView yearTextView = new TextView((Context)this.activity);
        yearTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        yearTextView.setTextSize((float)this.textSize);
        yearTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
            yearTextView.setText((CharSequence)this.yearLabel);
        }
        layout.addView((View)yearTextView);
        final WheelView monthView = new WheelView(this.activity.getBaseContext());
        monthView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        monthView.setTextSize(this.textSize);
        monthView.setTextColor(this.textColorNormal, this.textColorFocus);
        monthView.setLineVisible(this.lineVisible);
        monthView.setLineColor(this.lineColor);
        monthView.setOffset(this.offset);
        monthView.setCycleDisable(this.cycleDisable);
        layout.addView((View)monthView);
        TextView monthTextView = new TextView((Context)this.activity);
        monthTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        monthTextView.setTextSize((float)this.textSize);
        monthTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
            monthTextView.setText((CharSequence)this.monthLabel);
        }
        layout.addView((View)monthTextView);
        final WheelView dayView = new WheelView(this.activity.getBaseContext());
        dayView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        dayView.setTextSize(this.textSize);
        dayView.setTextColor(this.textColorNormal, this.textColorFocus);
        dayView.setLineVisible(this.lineVisible);
        dayView.setLineColor(this.lineColor);
        dayView.setOffset(this.offset);
        dayView.setCycleDisable(this.cycleDisable);
        layout.addView((View)dayView);
        TextView dayTextView = new TextView((Context)this.activity);
        dayTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        dayTextView.setTextSize((float)this.textSize);
        dayTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
            dayTextView.setText((CharSequence)this.dayLabel);
        }
        layout.addView((View)dayTextView);
        if (this.mode == 1) {
            dayView.setVisibility(8);
            dayTextView.setVisibility(8);
        } else if (this.mode == 2) {
            yearView.setVisibility(8);
            yearTextView.setVisibility(8);
        }
        if (this.mode != 2) {
            if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
                yearTextView.setText((CharSequence)this.yearLabel);
            }
            if (this.selectedYearIndex == 0) {
                yearView.setItems(this.years);
            } else {
                yearView.setItems(this.years, this.selectedYearIndex);
            }
            yearView.setOnWheelListener(new WheelView.OnWheelListener(){

                @Override
                public void onSelected(boolean isUserScroll, int index, String item) {
                    DatePicker.this.selectedYearIndex = index;
                    if (DatePicker.this.onWheelListener != null) {
                        DatePicker.this.onWheelListener.onYearWheeled(DatePicker.this.selectedYearIndex, item);
                    }
                    int year = DateUtils.trimZero((String)item);
                    DatePicker.this.changeDayData(year, DatePicker.this.changeMonthData(year));
                    monthView.setItems((List<String>)DatePicker.this.months, DatePicker.this.selectedMonthIndex);
                    dayView.setItems((List<String>)DatePicker.this.days, DatePicker.this.selectedDayIndex);
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
            monthTextView.setText((CharSequence)this.monthLabel);
        }
        if (this.selectedMonthIndex == 0) {
            monthView.setItems(this.months);
        } else {
            monthView.setItems(this.months, this.selectedMonthIndex);
        }
        monthView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                DatePicker.this.selectedMonthIndex = index;
                if (DatePicker.this.onWheelListener != null) {
                    DatePicker.this.onWheelListener.onMonthWheeled(DatePicker.this.selectedMonthIndex, item);
                }
                if (DatePicker.this.mode != 1) {
                    DatePicker.this.changeDayData(DateUtils.trimZero((String)((String)DatePicker.this.years.get(DatePicker.this.selectedYearIndex))), DateUtils.trimZero((String)item));
                    dayView.setItems((List<String>)DatePicker.this.days, DatePicker.this.selectedDayIndex);
                }
            }
        });
        if (this.mode != 1) {
            if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
                dayTextView.setText((CharSequence)this.dayLabel);
            }
            dayView.setItems(this.days, this.selectedDayIndex);
            dayView.setOnWheelListener(new WheelView.OnWheelListener(){

                @Override
                public void onSelected(boolean isUserScroll, int index, String item) {
                    DatePicker.this.selectedDayIndex = index;
                    if (DatePicker.this.onWheelListener != null) {
                        DatePicker.this.onWheelListener.onDayWheeled(DatePicker.this.selectedDayIndex, item);
                    }
                }
            });
        }
        return layout;
    }

    private int findItemIndex(ArrayList<String> items, int item) {
        int index = Collections.binarySearch(items, item, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                String lhsStr = lhs.toString();
                String rhsStr = rhs.toString();
                lhsStr = lhsStr.startsWith("0") ? lhsStr.substring(1) : lhsStr;
                rhsStr = rhsStr.startsWith("0") ? rhsStr.substring(1) : rhsStr;
                return Integer.parseInt(lhsStr) - Integer.parseInt(rhsStr);
            }
        });
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private void changeYearData() {
        this.years.clear();
        if (this.startYear == this.endYear) {
            this.years.add(String.valueOf(this.startYear));
        } else if (this.startYear < this.endYear) {
            for (int i = this.startYear; i <= this.endYear; ++i) {
                this.years.add(String.valueOf(i));
            }
        } else {
            for (int i = this.startYear; i >= this.endYear; --i) {
                this.years.add(String.valueOf(i));
            }
        }
    }

    private int changeMonthData(int year) {
        int i;
        String preSelectMonth = this.months.size() > this.selectedMonthIndex ? this.months.get(this.selectedMonthIndex) : null;
        this.months.clear();
        if (this.startMonth < 1 || this.endMonth < 1 || this.startMonth > 12 || this.endMonth > 12) {
            throw new IllegalArgumentException("month out of range [1-12]");
        }
        if (this.startMonth > this.endMonth) {
            int tmp = this.startMonth;
            this.startMonth = this.endMonth;
            this.endMonth = tmp;
        }
        if (this.startYear == this.endYear) {
            for (i = this.startMonth; i <= this.endMonth; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        } else if (year == this.startYear) {
            for (i = this.startMonth; i <= 12; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        } else if (year == this.endYear) {
            for (i = 1; i <= this.endMonth; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        } else {
            for (i = 1; i <= 12; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        }
        int preSelectMonthIndex = preSelectMonth == null ? 0 : this.months.indexOf(preSelectMonth);
        this.selectedMonthIndex = preSelectMonthIndex == -1 ? 0 : preSelectMonthIndex;
        return DateUtils.trimZero((String)this.months.get(this.selectedMonthIndex));
    }

    private void changeDayData(int year, int month) {
        String preSelectDay = this.days.size() > this.selectedDayIndex ? this.days.get(this.selectedDayIndex) : null;
        this.days.clear();
        int maxDays = DateUtils.calculateDaysInMonth((int)year, (int)month);
        if (year == this.startYear && month == this.startMonth) {
            for (int i = this.startDay; i <= maxDays; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
            int preSelectDayIndex = preSelectDay == null ? 0 : this.days.indexOf(preSelectDay);
            this.selectedDayIndex = preSelectDayIndex == -1 ? 0 : preSelectDayIndex;
        } else if (year == this.endYear && month == this.endMonth) {
            for (int i = 1; i <= this.endDay; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
            int preSelectDayIndex = preSelectDay == null ? 0 : this.days.indexOf(preSelectDay);
            this.selectedDayIndex = preSelectDayIndex == -1 ? 0 : preSelectDayIndex;
        } else {
            for (int i = 1; i <= maxDays; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
            if (this.selectedDayIndex >= maxDays) {
                this.selectedDayIndex = this.days.size() - 1;
            }
        }
    }

    protected void onSubmit() {
        if (this.onDatePickListener == null) {
            return;
        }
        String year = this.getSelectedYear();
        String month = this.getSelectedMonth();
        String day = this.getSelectedDay();
        switch (this.mode) {
            case 1: {
                ((OnYearMonthPickListener)this.onDatePickListener).onDatePicked(year, month);
                break;
            }
            case 2: {
                ((OnMonthDayPickListener)this.onDatePickListener).onDatePicked(month, day);
                break;
            }
            default: {
                ((OnYearMonthDayPickListener)this.onDatePickListener).onDatePicked(year, month, day);
            }
        }
    }

    public String getSelectedYear() {
        return this.years.get(this.selectedYearIndex);
    }

    public String getSelectedMonth() {
        return this.months.get(this.selectedMonthIndex);
    }

    public String getSelectedDay() {
        return this.days.get(this.selectedDayIndex);
    }

    public static interface OnWheelListener {
        public void onYearWheeled(int var1, String var2);

        public void onMonthWheeled(int var1, String var2);

        public void onDayWheeled(int var1, String var2);
    }

    public static interface OnMonthDayPickListener
    extends OnDatePickListener {
        public void onDatePicked(String var1, String var2);
    }

    public static interface OnYearMonthPickListener
    extends OnDatePickListener {
        public void onDatePicked(String var1, String var2);
    }

    public static interface OnYearMonthDayPickListener
    extends OnDatePickListener {
        public void onDatePicked(String var1, String var2, String var3);
    }

    protected static interface OnDatePickListener {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

