/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelpicker.contract.OnOptionSelectedListener;
import com.github.gzuliyujiang.wheelpicker.widget.BaseWheelLayout;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.Collections;
import java.util.List;

public class OptionWheelLayout
extends BaseWheelLayout {
    private WheelView wheelView;
    private TextView labelView;
    private OnOptionSelectedListener onOptionSelectedListener;

    public OptionWheelLayout(Context context) {
        super(context);
    }

    public OptionWheelLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public OptionWheelLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public OptionWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int provideLayoutRes() {
        return R.layout.wheel_picker_option;
    }

    @Override
    @CallSuper
    protected List<WheelView> provideWheelViews() {
        return Collections.singletonList(this.wheelView);
    }

    @Override
    @CallSuper
    protected void onInit(@NonNull Context context) {
        this.wheelView = (WheelView)this.findViewById(R.id.wheel_picker_option_wheel);
        this.labelView = (TextView)this.findViewById(R.id.wheel_picker_option_label);
    }

    @Override
    @CallSuper
    protected void onAttributeSet(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OptionWheelLayout);
        this.labelView.setText((CharSequence)typedArray.getString(R.styleable.OptionWheelLayout_wheel_label));
        typedArray.recycle();
    }

    @CallSuper
    public void onWheelSelected(WheelView view, int position) {
        if (this.onOptionSelectedListener != null) {
            this.onOptionSelectedListener.onOptionSelected(position, this.wheelView.getItem(position));
        }
    }

    public void setData(List<?> data) {
        this.wheelView.setData(data);
    }

    public void setDefaultValue(Object value) {
        this.wheelView.setDefaultValue(value);
    }

    public void setDefaultPosition(int position) {
        this.wheelView.setDefaultPosition(position);
    }

    public void setOnOptionSelectedListener(OnOptionSelectedListener onOptionSelectedListener) {
        this.onOptionSelectedListener = onOptionSelectedListener;
    }

    public final WheelView getWheelView() {
        return this.wheelView;
    }

    public final TextView getLabelView() {
        return this.labelView;
    }
}

