/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.entity;

import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class DateEntity
implements Serializable {
    private int year;
    private int month;
    private int day;

    public static DateEntity target(int year, int month, int dayOfMonth) {
        DateEntity entity = new DateEntity();
        entity.setYear(year);
        entity.setMonth(month);
        entity.setDay(dayOfMonth);
        return entity;
    }

    public static DateEntity target(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return DateEntity.target(year, month, day);
    }

    public static DateEntity target(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateEntity.target(calendar);
    }

    public static DateEntity today() {
        return DateEntity.target(Calendar.getInstance());
    }

    public static DateEntity dayOnFuture(int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, dayOfMonth);
        return DateEntity.target(calendar);
    }

    public static DateEntity monthOnFuture(int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, month);
        return DateEntity.target(calendar);
    }

    public static DateEntity yearOnFuture(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, year);
        return DateEntity.target(calendar);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public long toTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.year);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateEntity that = (DateEntity)o;
        return this.year == that.year && this.month == that.month && this.day == that.day;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day);
    }

    @NonNull
    public String toString() {
        return this.year + "-" + this.month + "-" + this.day;
    }
}

