/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.ModalDialog;
import com.github.gzuliyujiang.wheelpicker.contract.LinkageProvider;
import com.github.gzuliyujiang.wheelpicker.contract.OnLinkagePickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.LinkageWheelLayout;
import com.github.gzuliyujiang.wheelview.widget.WheelView;

public class LinkagePicker
extends ModalDialog {
    protected LinkageWheelLayout wheelLayout;
    private OnLinkagePickedListener onLinkagePickedListener;

    public LinkagePicker(@NonNull Activity activity) {
        super(activity);
    }

    public LinkagePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView() {
        this.wheelLayout = new LinkageWheelLayout((Context)this.activity);
        return this.wheelLayout;
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onLinkagePickedListener != null) {
            Object first = this.wheelLayout.getFirstWheelView().getCurrentItem();
            Object second = this.wheelLayout.getSecondWheelView().getCurrentItem();
            Object third = this.wheelLayout.getThirdWheelView().getCurrentItem();
            this.onLinkagePickedListener.onLinkagePicked(first, second, third);
        }
    }

    public void setData(@NonNull LinkageProvider data) {
        this.wheelLayout.setData(data);
    }

    public void setDefaultValue(Object first, Object second, Object third) {
        this.wheelLayout.setDefaultValue(first, second, third);
    }

    public void setOnLinkagePickedListener(OnLinkagePickedListener onLinkagePickedListener) {
        this.onLinkagePickedListener = onLinkagePickedListener;
    }

    public final LinkageWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }

    public final WheelView getFirstWheelView() {
        return this.wheelLayout.getFirstWheelView();
    }

    public final WheelView getSecondWheelView() {
        return this.wheelLayout.getSecondWheelView();
    }

    public final WheelView getThirdWheelView() {
        return this.wheelLayout.getThirdWheelView();
    }

    public final TextView getFirstLabelView() {
        return this.wheelLayout.getFirstLabelView();
    }

    public final TextView getSecondLabelView() {
        return this.wheelLayout.getSecondLabelView();
    }

    public final TextView getThirdLabelView() {
        return this.wheelLayout.getThirdLabelView();
    }

    public final ProgressBar getLoadingView() {
        return this.wheelLayout.getLoadingView();
    }
}

