/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.entity;

import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class TimeEntity
implements Serializable {
    private int hour;
    private int minute;
    private int second;

    public static TimeEntity target(int hour, int minute, int second) {
        TimeEntity entity = new TimeEntity();
        entity.setHour(hour);
        entity.setMinute(minute);
        entity.setSecond(second);
        return entity;
    }

    public static TimeEntity target(Calendar calendar) {
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return TimeEntity.target(hour, minute, second);
    }

    public static TimeEntity target(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return TimeEntity.target(calendar);
    }

    public static TimeEntity now() {
        return TimeEntity.target(Calendar.getInstance());
    }

    public static TimeEntity minuteOnFuture(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, minute);
        return TimeEntity.target(calendar);
    }

    public static TimeEntity hourOnFuture(int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, hour);
        return TimeEntity.target(calendar);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public long toTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @NonNull
    public String toString() {
        return this.hour + ":" + this.minute + ":" + this.second;
    }
}

