/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelpicker.contract.LinkageProvider;
import com.github.gzuliyujiang.wheelpicker.contract.OnLinkageSelectedListener;
import com.github.gzuliyujiang.wheelpicker.widget.BaseWheelLayout;
import com.github.gzuliyujiang.wheelview.contract.WheelFormatter;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.Arrays;
import java.util.List;

public class LinkageWheelLayout
extends BaseWheelLayout {
    private WheelView firstWheelView;
    private WheelView secondWheelView;
    private WheelView thirdWheelView;
    private TextView firstLabelView;
    private TextView secondLabelView;
    private TextView thirdLabelView;
    private ProgressBar loadingView;
    private Object firstValue;
    private Object secondValue;
    private Object thirdValue;
    private int firstIndex;
    private int secondIndex;
    private int thirdIndex;
    private LinkageProvider dataProvider;
    private OnLinkageSelectedListener onLinkageSelectedListener;

    public LinkageWheelLayout(Context context) {
        super(context);
    }

    public LinkageWheelLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LinkageWheelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public LinkageWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int provideLayoutRes() {
        return R.layout.wheel_picker_linkage;
    }

    @Override
    @CallSuper
    protected List<WheelView> provideWheelViews() {
        return Arrays.asList(this.firstWheelView, this.secondWheelView, this.thirdWheelView);
    }

    @Override
    @CallSuper
    protected void onInit(@NonNull Context context) {
        this.firstWheelView = (WheelView)this.findViewById(R.id.wheel_picker_linkage_first_wheel);
        this.secondWheelView = (WheelView)this.findViewById(R.id.wheel_picker_linkage_second_wheel);
        this.thirdWheelView = (WheelView)this.findViewById(R.id.wheel_picker_linkage_third_wheel);
        this.firstLabelView = (TextView)this.findViewById(R.id.wheel_picker_linkage_first_label);
        this.secondLabelView = (TextView)this.findViewById(R.id.wheel_picker_linkage_second_label);
        this.thirdLabelView = (TextView)this.findViewById(R.id.wheel_picker_linkage_third_label);
        this.loadingView = (ProgressBar)this.findViewById(R.id.wheel_picker_linkage_loading);
    }

    @Override
    @CallSuper
    protected void onAttributeSet(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LinkageWheelLayout);
        this.setFirstVisible(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_firstVisible, true));
        this.setThirdVisible(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_thirdVisible, true));
        String firstLabel = typedArray.getString(R.styleable.LinkageWheelLayout_wheel_firstLabel);
        String secondLabel = typedArray.getString(R.styleable.LinkageWheelLayout_wheel_secondLabel);
        String thirdLabel = typedArray.getString(R.styleable.LinkageWheelLayout_wheel_thirdLabel);
        typedArray.recycle();
        this.setLabel(firstLabel, secondLabel, thirdLabel);
    }

    @CallSuper
    public void onWheelSelected(WheelView view, int position) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_linkage_first_wheel) {
            this.firstIndex = position;
            this.secondIndex = 0;
            this.thirdIndex = 0;
            this.changeSecondData();
            this.changeThirdData();
            this.selectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_second_wheel) {
            this.secondIndex = position;
            this.thirdIndex = 0;
            this.changeThirdData();
            this.selectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_third_wheel) {
            this.thirdIndex = position;
            this.selectedCallback();
        }
    }

    @Override
    @CallSuper
    public void onWheelScrollStateChanged(WheelView view, int state) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_linkage_first_wheel) {
            this.secondWheelView.setEnabled(state == 0);
            this.thirdWheelView.setEnabled(state == 0);
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_second_wheel) {
            this.firstWheelView.setEnabled(state == 0);
            this.thirdWheelView.setEnabled(state == 0);
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_third_wheel) {
            this.firstWheelView.setEnabled(state == 0);
            this.secondWheelView.setEnabled(state == 0);
        }
    }

    public void setData(@NonNull LinkageProvider provider) {
        this.setFirstVisible(provider.firstLevelVisible());
        this.setThirdVisible(provider.thirdLevelVisible());
        if (this.firstValue != null) {
            this.firstIndex = provider.findFirstIndex(this.firstValue);
        }
        if (this.secondValue != null) {
            this.secondIndex = provider.findSecondIndex(this.firstIndex, this.secondValue);
        }
        if (this.thirdValue != null) {
            this.thirdIndex = provider.findThirdIndex(this.firstIndex, this.secondIndex, this.thirdValue);
        }
        this.dataProvider = provider;
        this.changeFirstData();
        this.changeSecondData();
        this.changeThirdData();
    }

    public void setDefaultValue(Object first, Object second, Object third) {
        if (this.dataProvider != null) {
            this.firstIndex = this.dataProvider.findFirstIndex(first);
            this.secondIndex = this.dataProvider.findSecondIndex(this.firstIndex, second);
            this.thirdIndex = this.dataProvider.findThirdIndex(this.firstIndex, this.secondIndex, third);
            this.changeFirstData();
            this.changeSecondData();
            this.changeThirdData();
        } else {
            this.firstValue = first;
            this.secondValue = second;
            this.thirdValue = third;
        }
    }

    public void setFormatter(WheelFormatter first, WheelFormatter second, WheelFormatter third) {
        this.firstWheelView.setFormatter(first);
        this.secondWheelView.setFormatter(second);
        this.thirdWheelView.setFormatter(third);
    }

    public void setLabel(CharSequence first, CharSequence second, CharSequence third) {
        this.firstLabelView.setText(first);
        this.secondLabelView.setText(second);
        this.thirdLabelView.setText(third);
    }

    public void showLoading() {
        this.loadingView.setVisibility(0);
    }

    public void hideLoading() {
        this.loadingView.setVisibility(8);
    }

    public void setOnLinkageSelectedListener(OnLinkageSelectedListener onLinkageSelectedListener) {
        this.onLinkageSelectedListener = onLinkageSelectedListener;
    }

    public void setFirstVisible(boolean visible) {
        if (visible) {
            this.firstWheelView.setVisibility(0);
            this.firstLabelView.setVisibility(0);
        } else {
            this.firstWheelView.setVisibility(8);
            this.firstLabelView.setVisibility(8);
        }
    }

    public void setThirdVisible(boolean visible) {
        if (visible) {
            this.thirdWheelView.setVisibility(0);
            this.thirdLabelView.setVisibility(0);
        } else {
            this.thirdWheelView.setVisibility(8);
            this.thirdLabelView.setVisibility(8);
        }
    }

    private void selectedCallback() {
        if (this.onLinkageSelectedListener == null) {
            return;
        }
        this.thirdWheelView.post(new Runnable(){

            @Override
            public void run() {
                Object first = LinkageWheelLayout.this.firstWheelView.getCurrentItem();
                Object second = LinkageWheelLayout.this.secondWheelView.getCurrentItem();
                Object third = LinkageWheelLayout.this.thirdWheelView.getCurrentItem();
                LinkageWheelLayout.this.onLinkageSelectedListener.onLinkageSelected(first, second, third);
            }
        });
    }

    private void changeFirstData() {
        this.firstWheelView.setData(this.dataProvider.provideFirstData());
        this.firstWheelView.setDefaultPosition(this.firstIndex);
    }

    private void changeSecondData() {
        this.secondWheelView.setData(this.dataProvider.linkageSecondData(this.firstIndex));
        this.secondWheelView.setDefaultPosition(this.secondIndex);
    }

    private void changeThirdData() {
        if (!this.dataProvider.thirdLevelVisible()) {
            return;
        }
        this.thirdWheelView.setData(this.dataProvider.linkageThirdData(this.firstIndex, this.secondIndex));
        this.thirdWheelView.setDefaultPosition(this.thirdIndex);
    }

    public final WheelView getFirstWheelView() {
        return this.firstWheelView;
    }

    public final WheelView getSecondWheelView() {
        return this.secondWheelView;
    }

    public final WheelView getThirdWheelView() {
        return this.thirdWheelView;
    }

    public final TextView getFirstLabelView() {
        return this.firstLabelView;
    }

    public final TextView getSecondLabelView() {
        return this.secondLabelView;
    }

    public final TextView getThirdLabelView() {
        return this.thirdLabelView;
    }

    public final ProgressBar getLoadingView() {
        return this.loadingView;
    }
}

