/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelpicker.contract.DateFormatter;
import com.github.gzuliyujiang.wheelpicker.contract.OnDatimeSelectedListener;
import com.github.gzuliyujiang.wheelpicker.contract.TimeFormatter;
import com.github.gzuliyujiang.wheelpicker.entity.DatimeEntity;
import com.github.gzuliyujiang.wheelpicker.impl.SimpleDateFormatter;
import com.github.gzuliyujiang.wheelpicker.impl.SimpleTimeFormatter;
import com.github.gzuliyujiang.wheelpicker.widget.BaseWheelLayout;
import com.github.gzuliyujiang.wheelpicker.widget.DateWheelLayout;
import com.github.gzuliyujiang.wheelpicker.widget.TimeWheelLayout;
import com.github.gzuliyujiang.wheelview.widget.NumberWheelView;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class DatimeWheelLayout
extends BaseWheelLayout {
    private DateWheelLayout dateWheelLayout;
    private TimeWheelLayout timeWheelLayout;
    private DatimeEntity startValue;
    private DatimeEntity endValue;
    private OnDatimeSelectedListener onDatimeSelectedListener;

    public DatimeWheelLayout(Context context) {
        super(context);
    }

    public DatimeWheelLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DatimeWheelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public DatimeWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int provideLayoutRes() {
        return R.layout.wheel_picker_datime;
    }

    @Override
    protected int[] provideStyleableRes() {
        return R.styleable.DatimeWheelLayout;
    }

    @Override
    protected List<WheelView> provideWheelViews() {
        ArrayList<WheelView> list = new ArrayList<WheelView>();
        list.addAll(this.dateWheelLayout.provideWheelViews());
        list.addAll(this.timeWheelLayout.provideWheelViews());
        return list;
    }

    @Override
    protected void onInit(@NonNull Context context) {
        this.dateWheelLayout = (DateWheelLayout)this.findViewById(R.id.wheel_picker_date_wheel);
        this.timeWheelLayout = (TimeWheelLayout)this.findViewById(R.id.wheel_picker_time_wheel);
    }

    @Override
    protected void onAttributeSet(@NonNull Context context, @NonNull TypedArray typedArray) {
        float density = context.getResources().getDisplayMetrics().density;
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.setVisibleItemCount(typedArray.getInt(R.styleable.DatimeWheelLayout_wheel_visibleItemCount, 5));
        this.setSameWidthEnabled(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_sameWidthEnabled, false));
        this.setMaxWidthText(typedArray.getString(R.styleable.DatimeWheelLayout_wheel_maxWidthText));
        this.setSelectedTextColor(typedArray.getColor(R.styleable.DatimeWheelLayout_wheel_itemTextColorSelected, -16777216));
        this.setTextColor(typedArray.getColor(R.styleable.DatimeWheelLayout_wheel_itemTextColor, -7829368));
        this.setTextSize(typedArray.getDimension(R.styleable.DatimeWheelLayout_wheel_itemTextSize, 15.0f * scaledDensity));
        this.setSelectedTextSize(typedArray.getDimension(R.styleable.DatimeWheelLayout_wheel_itemTextSizeSelected, 16.0f * scaledDensity));
        this.setSelectedTextBold(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_itemTextBoldSelected, false));
        this.setTextAlign(typedArray.getInt(R.styleable.DatimeWheelLayout_wheel_itemTextAlign, 0));
        this.setItemSpace(typedArray.getDimensionPixelSize(R.styleable.DatimeWheelLayout_wheel_itemSpace, (int)(20.0f * density)));
        this.setCyclicEnabled(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_cyclicEnabled, false));
        this.setIndicatorEnabled(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_indicatorEnabled, false));
        this.setIndicatorColor(typedArray.getColor(R.styleable.DatimeWheelLayout_wheel_indicatorColor, -3552823));
        this.setIndicatorSize(typedArray.getDimension(R.styleable.DatimeWheelLayout_wheel_indicatorSize, 1.0f * density));
        this.setCurvedIndicatorSpace(typedArray.getDimensionPixelSize(R.styleable.DatimeWheelLayout_wheel_curvedIndicatorSpace, (int)(1.0f * density)));
        this.setCurtainEnabled(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_curtainEnabled, false));
        this.setCurtainColor(typedArray.getColor(R.styleable.DatimeWheelLayout_wheel_curtainColor, -1996488705));
        this.setCurtainCorner(typedArray.getInt(R.styleable.DatimeWheelLayout_wheel_curtainCorner, 0));
        this.setCurtainRadius(typedArray.getDimension(R.styleable.DatimeWheelLayout_wheel_curtainRadius, 0.0f));
        this.setAtmosphericEnabled(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_atmosphericEnabled, false));
        this.setCurvedEnabled(typedArray.getBoolean(R.styleable.DatimeWheelLayout_wheel_curvedEnabled, false));
        this.setCurvedMaxAngle(typedArray.getInteger(R.styleable.DatimeWheelLayout_wheel_curvedMaxAngle, 90));
        this.setDateMode(typedArray.getInt(R.styleable.DatimeWheelLayout_wheel_dateMode, 0));
        this.setTimeMode(typedArray.getInt(R.styleable.DatimeWheelLayout_wheel_timeMode, 0));
        String yearLabel = typedArray.getString(R.styleable.DatimeWheelLayout_wheel_yearLabel);
        String monthLabel = typedArray.getString(R.styleable.DatimeWheelLayout_wheel_monthLabel);
        String dayLabel = typedArray.getString(R.styleable.DatimeWheelLayout_wheel_dayLabel);
        this.setDateLabel(yearLabel, monthLabel, dayLabel);
        String hourLabel = typedArray.getString(R.styleable.DatimeWheelLayout_wheel_hourLabel);
        String minuteLabel = typedArray.getString(R.styleable.DatimeWheelLayout_wheel_minuteLabel);
        String secondLabel = typedArray.getString(R.styleable.DatimeWheelLayout_wheel_secondLabel);
        this.setTimeLabel(hourLabel, minuteLabel, secondLabel);
        this.setDateFormatter(new SimpleDateFormatter());
        this.setTimeFormatter(new SimpleTimeFormatter(this.timeWheelLayout));
        this.setRange(DatimeEntity.now(), DatimeEntity.yearOnFuture(30), DatimeEntity.now());
    }

    public void onWheelSelected(WheelView view, int position) {
        this.dateWheelLayout.onWheelSelected(view, position);
        this.timeWheelLayout.onWheelSelected(view, position);
        if (this.onDatimeSelectedListener == null) {
            return;
        }
        this.timeWheelLayout.post(new Runnable(){

            @Override
            public void run() {
                DatimeWheelLayout.this.onDatimeSelectedListener.onDatimeSelected(DatimeWheelLayout.this.dateWheelLayout.getSelectedYear(), DatimeWheelLayout.this.dateWheelLayout.getSelectedMonth(), DatimeWheelLayout.this.dateWheelLayout.getSelectedDay(), DatimeWheelLayout.this.timeWheelLayout.getSelectedHour(), DatimeWheelLayout.this.timeWheelLayout.getSelectedMinute(), DatimeWheelLayout.this.timeWheelLayout.getSelectedSecond());
            }
        });
    }

    @Override
    public void onWheelScrolled(WheelView view, int offset) {
        this.dateWheelLayout.onWheelScrolled(view, offset);
        this.timeWheelLayout.onWheelScrolled(view, offset);
    }

    @Override
    public void onWheelScrollStateChanged(WheelView view, int state) {
        this.dateWheelLayout.onWheelScrollStateChanged(view, state);
        this.timeWheelLayout.onWheelScrollStateChanged(view, state);
    }

    @Override
    public void onWheelLoopFinished(WheelView view) {
        this.dateWheelLayout.onWheelLoopFinished(view);
        this.timeWheelLayout.onWheelLoopFinished(view);
    }

    public void setDateMode(int dateMode) {
        this.dateWheelLayout.setDateMode(dateMode);
    }

    public void setTimeMode(int timeMode) {
        this.timeWheelLayout.setTimeMode(timeMode);
    }

    public void setRange(DatimeEntity startValue, DatimeEntity endValue) {
        this.setRange(startValue, endValue, null);
    }

    public void setRange(DatimeEntity startValue, DatimeEntity endValue, DatimeEntity defaultValue) {
        if (startValue == null) {
            startValue = DatimeEntity.now();
        }
        if (endValue == null) {
            endValue = DatimeEntity.yearOnFuture(10);
        }
        if (defaultValue == null) {
            defaultValue = startValue;
        }
        this.dateWheelLayout.setRange(startValue.getDate(), endValue.getDate(), defaultValue.getDate());
        this.timeWheelLayout.setRange(null, null, defaultValue.getTime());
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public void setDefaultValue(DatimeEntity defaultValue) {
        if (defaultValue == null) {
            defaultValue = DatimeEntity.now();
        }
        this.dateWheelLayout.setDefaultValue(defaultValue.getDate());
        this.timeWheelLayout.setDefaultValue(defaultValue.getTime());
    }

    public void setDateFormatter(DateFormatter dateFormatter) {
        this.dateWheelLayout.setDateFormatter(dateFormatter);
    }

    public void setTimeFormatter(TimeFormatter timeFormatter) {
        this.timeWheelLayout.setTimeFormatter(timeFormatter);
    }

    public void setDateLabel(CharSequence year, CharSequence month, CharSequence day) {
        this.dateWheelLayout.setDateLabel(year, month, day);
    }

    public void setTimeLabel(CharSequence hour, CharSequence minute, CharSequence second) {
        this.timeWheelLayout.setTimeLabel(hour, minute, second);
    }

    public void setOnDatimeSelectedListener(OnDatimeSelectedListener onDatimeSelectedListener) {
        this.onDatimeSelectedListener = onDatimeSelectedListener;
    }

    public final DatimeEntity getStartValue() {
        return this.startValue;
    }

    public final DatimeEntity getEndValue() {
        return this.endValue;
    }

    public final DateWheelLayout getDateWheelLayout() {
        return this.dateWheelLayout;
    }

    public final TimeWheelLayout getTimeWheelLayout() {
        return this.timeWheelLayout;
    }

    public final NumberWheelView getYearWheelView() {
        return this.dateWheelLayout.getYearWheelView();
    }

    public final NumberWheelView getMonthWheelView() {
        return this.dateWheelLayout.getMonthWheelView();
    }

    public final NumberWheelView getDayWheelView() {
        return this.dateWheelLayout.getDayWheelView();
    }

    public final NumberWheelView getHourWheelView() {
        return this.timeWheelLayout.getHourWheelView();
    }

    public final NumberWheelView getMinuteWheelView() {
        return this.timeWheelLayout.getMinuteWheelView();
    }

    public final NumberWheelView getSecondWheelView() {
        return this.timeWheelLayout.getSecondWheelView();
    }

    public final WheelView getMeridiemWheelView() {
        return this.timeWheelLayout.getMeridiemWheelView();
    }

    public final TextView getYearLabelView() {
        return this.dateWheelLayout.getYearLabelView();
    }

    public final TextView getMonthLabelView() {
        return this.dateWheelLayout.getMonthLabelView();
    }

    public final TextView getDayLabelView() {
        return this.dateWheelLayout.getDayLabelView();
    }

    public final TextView getHourLabelView() {
        return this.timeWheelLayout.getHourLabelView();
    }

    public final TextView getMinuteLabelView() {
        return this.timeWheelLayout.getMinuteLabelView();
    }

    public final TextView getSecondLabelView() {
        return this.timeWheelLayout.getSecondLabelView();
    }

    public final int getSelectedYear() {
        return this.dateWheelLayout.getSelectedYear();
    }

    public final int getSelectedMonth() {
        return this.dateWheelLayout.getSelectedMonth();
    }

    public final int getSelectedDay() {
        return this.dateWheelLayout.getSelectedDay();
    }

    public final int getSelectedHour() {
        return this.timeWheelLayout.getSelectedHour();
    }

    public final int getSelectedMinute() {
        return this.timeWheelLayout.getSelectedMinute();
    }

    public final int getSelectedSecond() {
        return this.timeWheelLayout.getSelectedSecond();
    }
}

