/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.wheelpicker.OptionPicker;
import com.github.gzuliyujiang.wheelpicker.entity.SexEntity;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SexPicker
extends OptionPicker {
    public static String JSON = "[{\"id\":0,\"name\":\"\u4fdd\u5bc6\",\"english\":\"Secrecy\"},\n{\"id\":1,\"name\":\"\u7537\",\"english\":\"Male\"},\n{\"id\":2,\"name\":\"\u5973\",\"english\":\"Female\"}]";
    private boolean includeSecrecy;

    public SexPicker(Activity activity) {
        super(activity);
    }

    public SexPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    public void setIncludeSecrecy(boolean includeSecrecy) {
        this.includeSecrecy = includeSecrecy;
        this.setData(this.provideData());
    }

    @Override
    public void setDefaultValue(Object item) {
        if (item instanceof String) {
            this.setDefaultValueByName(item.toString());
        } else {
            super.setDefaultValue(item);
        }
    }

    public void setDefaultValueByName(String name) {
        SexEntity entity = new SexEntity();
        entity.setName(name);
        super.setDefaultValue(entity);
    }

    public void setDefaultValueByEnglish(String english) {
        SexEntity entity = new SexEntity();
        entity.setEnglish(english);
        super.setDefaultValue(entity);
    }

    @Override
    protected List<?> provideData() {
        ArrayList<SexEntity> data = new ArrayList<SexEntity>();
        try {
            JSONArray jsonArray = new JSONArray(JSON);
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                SexEntity entity = new SexEntity();
                entity.setId(jsonObject.getString("id"));
                entity.setName(jsonObject.getString("name"));
                entity.setEnglish(jsonObject.getString("english"));
                if (!this.includeSecrecy && "0".equals(entity.getId())) continue;
                data.add(entity);
            }
        }
        catch (JSONException e) {
            DialogLog.print((Object)((Object)e));
        }
        return data;
    }
}

