/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.wheelpicker.OptionPicker;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ConstellationPicker
extends OptionPicker {
    public static final List<String> DATA_CN = Arrays.asList("\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7");
    public static final List<String> DATA_EN = Arrays.asList("Aquarius", "Pisces", "Aries", "Taurus", "Gemini", "Cancer", "Leo", "Virgo", "Libra", "Scorpio", "Sagittarius", "Capricorn");
    private final boolean includeUnlimited;

    public ConstellationPicker(Activity activity) {
        this(activity, false);
    }

    public ConstellationPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
        this.includeUnlimited = false;
    }

    public ConstellationPicker(@NonNull Activity activity, @StyleRes int themeResId, boolean includeUnlimited) {
        super(activity, themeResId);
        this.includeUnlimited = includeUnlimited;
    }

    public ConstellationPicker(Activity activity, boolean includeUnlimited) {
        super(activity);
        this.includeUnlimited = includeUnlimited;
    }

    @Override
    protected void initView() {
        super.initView();
        this.titleView.setText((CharSequence)"\u661f\u5ea7\u9009\u62e9");
    }

    @Override
    protected List<?> provideData() {
        boolean isChinese = Locale.getDefault().getDisplayLanguage().contains("\u4e2d\u6587");
        LinkedList<String> data = new LinkedList<String>();
        if (isChinese) {
            data.addAll(DATA_CN);
            if (this.includeUnlimited) {
                data.addFirst("\u4e0d\u9650");
            }
        } else {
            data.addAll(DATA_EN);
            if (this.includeUnlimited) {
                data.addFirst("Unlimited");
            }
        }
        return data;
    }
}

