/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.wheelpicker.DatePicker;
import com.github.gzuliyujiang.wheelpicker.entity.DateEntity;
import com.github.gzuliyujiang.wheelpicker.impl.BirthdayFormatter;
import java.util.Calendar;

public class BirthdayPicker
extends DatePicker {
    private static final int MAX_AGE = 100;

    public BirthdayPicker(@NonNull Activity activity) {
        super(activity);
    }

    public BirthdayPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @Override
    protected void initView() {
        super.initView();
        this.titleView.setText((CharSequence)"\u751f\u65e5\u9009\u62e9");
    }

    protected void initData() {
        super.initData();
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentMonth = calendar.get(2) + 1;
        int currentDay = calendar.get(5);
        DateEntity startValue = DateEntity.target(currentYear - 100, 1, 1);
        DateEntity endValue = DateEntity.target(currentYear, currentMonth, currentDay);
        this.wheelLayout.setRange(startValue, endValue);
        this.wheelLayout.setDateMode(0);
        this.wheelLayout.setDateFormatter(new BirthdayFormatter());
    }

    public void setDefaultValue(int year, int month, int day) {
        this.wheelLayout.setDefaultValue(DateEntity.target(year, month, day));
    }
}

