/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.ModalDialog;
import com.github.gzuliyujiang.wheelpicker.contract.OnNumberPickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.NumberWheelLayout;
import com.github.gzuliyujiang.wheelview.contract.WheelFormatter;
import com.github.gzuliyujiang.wheelview.widget.WheelView;

public class NumberPicker
extends ModalDialog {
    protected NumberWheelLayout wheelLayout;
    private OnNumberPickedListener onNumberPickedListener;

    public NumberPicker(@NonNull Activity activity) {
        super(activity);
    }

    public NumberPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView() {
        this.wheelLayout = new NumberWheelLayout((Context)this.activity);
        return this.wheelLayout;
    }

    protected void initData() {
        super.initData();
        this.titleView.setText((CharSequence)"\u8bf7\u9009\u62e9");
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onNumberPickedListener != null) {
            int position = this.wheelLayout.getWheelView().getCurrentPosition();
            Object item = this.wheelLayout.getWheelView().getCurrentItem();
            this.onNumberPickedListener.onNumberPicked(position, (Number)item);
        }
    }

    public void setFormatter(WheelFormatter formatter) {
        this.wheelLayout.getWheelView().setFormatter(formatter);
    }

    public void setRange(int min, int max, int step) {
        this.wheelLayout.setRange(min, max, step);
    }

    public void setRange(float min, float max, float step) {
        this.wheelLayout.setRange(min, max, step);
    }

    public void setDefaultValue(Object item) {
        this.wheelLayout.setDefaultValue(item);
    }

    public void setDefaultPosition(int position) {
        this.wheelLayout.setDefaultPosition(position);
    }

    public final void setOnNumberPickedListener(OnNumberPickedListener onNumberPickedListener) {
        this.onNumberPickedListener = onNumberPickedListener;
    }

    public final NumberWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }

    public final WheelView getWheelView() {
        return this.wheelLayout.getWheelView();
    }

    public final TextView getLabelView() {
        return this.wheelLayout.getLabelView();
    }
}

