/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.ConfirmPicker;
import com.github.gzuliyujiang.wheelpicker.contract.OnDatimePickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.DatimeWheelLayout;

public class DatimePicker
extends ConfirmPicker {
    protected DatimeWheelLayout wheelLayout;
    private OnDatimePickedListener onDatimePickedListener;

    public DatimePicker(@NonNull Activity activity) {
        super(activity);
    }

    public DatimePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView(@NonNull Activity activity) {
        this.wheelLayout = new DatimeWheelLayout((Context)activity);
        return this.wheelLayout;
    }

    @Deprecated
    protected int provideDateMode() {
        throw new UnsupportedOperationException("Use `picker.getWheelLayout().setDateMode()` instead");
    }

    @Deprecated
    protected int provideTimeMode() {
        throw new UnsupportedOperationException("Use `picker.getWheelLayout().setTimeMode()` instead");
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onDatimePickedListener != null) {
            int year = this.wheelLayout.getSelectedYear();
            int month = this.wheelLayout.getSelectedMonth();
            int day = this.wheelLayout.getSelectedDay();
            int hour = this.wheelLayout.getSelectedHour();
            int minute = this.wheelLayout.getSelectedMinute();
            int second = this.wheelLayout.getSelectedSecond();
            this.onDatimePickedListener.onDatimePicked(year, month, day, hour, minute, second);
        }
    }

    public void setOnDatimePickedListener(OnDatimePickedListener onDatimePickedListener) {
        this.onDatimePickedListener = onDatimePickedListener;
    }

    public final DatimeWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }
}

