/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.ConfirmPicker;
import com.github.gzuliyujiang.wheelpicker.contract.OnDatePickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.DateWheelLayout;

public class DatePicker
extends ConfirmPicker {
    protected DateWheelLayout wheelLayout;
    private OnDatePickedListener onDatePickedListener;

    public DatePicker(@NonNull Activity activity) {
        super(activity);
    }

    public DatePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView(@NonNull Activity activity) {
        this.wheelLayout = new DateWheelLayout((Context)activity);
        return this.wheelLayout;
    }

    protected void initView(@NonNull View contentView) {
        super.initView(contentView);
    }

    @Deprecated
    protected int provideDateMode() {
        throw new UnsupportedOperationException("Use `picker.getWheelLayout().setDateMode()` instead");
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onDatePickedListener != null) {
            int year = this.wheelLayout.getSelectedYear();
            int month = this.wheelLayout.getSelectedMonth();
            int day = this.wheelLayout.getSelectedDay();
            this.onDatePickedListener.onDatePicked(year, month, day);
        }
    }

    public void setOnDatePickedListener(OnDatePickedListener onDatePickedListener) {
        this.onDatePickedListener = onDatePickedListener;
    }

    public final DateWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }
}

