/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import androidx.annotation.StyleableRes;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelview.contract.OnWheelChangedListener;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseWheelLayout
extends LinearLayout
implements OnWheelChangedListener {
    private final List<WheelView> wheelViews = new ArrayList<WheelView>();
    private AttributeSet attrs;

    public BaseWheelLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public BaseWheelLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, this.provideStyleableRes(), R.attr.WheelStyle, R.style.WheelDefault);
        this.onAttributeSet(context, a);
        a.recycle();
    }

    public BaseWheelLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, this.provideStyleableRes(), defStyleAttr, R.style.WheelDefault);
        this.onAttributeSet(context, a);
        a.recycle();
    }

    public BaseWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, this.provideStyleableRes(), defStyleAttr, defStyleRes);
        this.onAttributeSet(context, a);
        a.recycle();
    }

    private void init(Context context, AttributeSet attrs) {
        this.attrs = attrs;
        this.setOrientation(1);
        BaseWheelLayout.inflate((Context)context, (int)this.provideLayoutRes(), (ViewGroup)this);
        this.onInit(context);
        this.wheelViews.addAll(this.provideWheelViews());
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setOnWheelChangedListener((OnWheelChangedListener)this);
        }
    }

    protected void onInit(@NonNull Context context) {
    }

    protected void onAttributeSet(@NonNull Context context, @NonNull TypedArray typedArray) {
    }

    @LayoutRes
    protected abstract int provideLayoutRes();

    @StyleableRes
    protected abstract int[] provideStyleableRes();

    protected abstract List<WheelView> provideWheelViews();

    public void setStyle(@StyleRes int style2) {
        if (this.attrs == null) {
            throw new RuntimeException("Please use " + ((Object)((Object)this)).getClass().getSimpleName() + " in xml");
        }
        TypedArray a = this.getContext().obtainStyledAttributes(this.attrs, this.provideStyleableRes(), R.attr.WheelStyle, style2);
        this.onAttributeSet(this.getContext(), a);
        a.recycle();
        this.requestLayout();
        this.postInvalidate();
    }

    public void onWheelScrolled(WheelView view, int offset) {
    }

    public void onWheelScrollStateChanged(WheelView view, int state) {
    }

    public void onWheelLoopFinished(WheelView view) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setEnabled(enabled);
        }
    }

    public void setCurtainEnabled(boolean hasCurtain) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurtainEnabled(hasCurtain);
        }
    }

    public void setCurtainColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurtainColor(color);
        }
    }

    public void setAtmosphericEnabled(boolean hasAtmospheric) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setAtmosphericEnabled(hasAtmospheric);
        }
    }

    public void setCurvedEnabled(boolean curved) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurvedEnabled(curved);
        }
    }

    public void setCurvedMaxAngle(int curvedMaxAngle) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurvedMaxAngle(curvedMaxAngle);
        }
    }

    public void setCurvedIndicatorSpace(@Px int space) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurvedIndicatorSpace(space);
        }
    }

    public void setItemSpace(@Px int space) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setItemSpace(space);
        }
    }

    public void setCyclicEnabled(boolean cyclic) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCyclicEnabled(cyclic);
        }
    }

    public void setIndicatorEnabled(boolean hasIndicator) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setIndicatorEnabled(hasIndicator);
        }
    }

    public void setIndicatorSize(@Px float size) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setIndicatorSize(size);
        }
    }

    public void setIndicatorColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setIndicatorColor(color);
        }
    }

    public void setTextSize(@Px int textSize) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setTextSize(textSize);
        }
    }

    public void setSameWidthEnabled(boolean sameWidthEnabled) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setSameWidthEnabled(sameWidthEnabled);
        }
    }

    public void setDefaultItemPosition(int position) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setDefaultPosition(position);
        }
    }

    public void setMaxWidthText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setMaxWidthText(text);
        }
    }

    public void setSelectedTextColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setSelectedTextColor(color);
        }
    }

    public void setTextColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setTextColor(color);
        }
    }

    public void setVisibleItemCount(int visibleItemCount) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setVisibleItemCount(visibleItemCount);
        }
    }

    public void setTextAlign(int align) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setTextAlign(align);
        }
    }
}

