/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.ConfirmPicker;
import com.github.gzuliyujiang.wheelpicker.contract.OnOptionPickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.OptionWheelLayout;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.Arrays;
import java.util.List;

public class OptionPicker
extends ConfirmPicker {
    protected OptionWheelLayout wheelLayout;
    private OnOptionPickedListener onOptionPickedListener;
    private boolean initialized = false;
    private List<?> data;
    private Object defaultValue;
    private int defaultPosition = -1;

    public OptionPicker(@NonNull Activity activity) {
        super(activity);
    }

    public OptionPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView(@NonNull Activity activity) {
        this.wheelLayout = new OptionWheelLayout((Context)activity);
        return this.wheelLayout;
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onOptionPickedListener != null) {
            int position = this.wheelLayout.getWheelView().getCurrentPosition();
            Object item = this.wheelLayout.getWheelView().getCurrentItem();
            this.onOptionPickedListener.onOptionPicked(position, item);
        }
    }

    protected void initData() {
        super.initData();
        this.initialized = true;
        if (this.data == null || this.data.size() == 0) {
            this.data = this.provideData();
        }
        this.wheelLayout.setData(this.data);
        if (this.defaultValue != null) {
            this.wheelLayout.setDefaultValue(this.defaultValue);
        }
        if (this.defaultPosition != -1) {
            this.wheelLayout.setDefaultPosition(this.defaultPosition);
        }
    }

    protected List<?> provideData() {
        return null;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public void setData(Object ... data) {
        this.setData(Arrays.asList(data));
    }

    public void setData(List<?> data) {
        this.data = data;
        if (this.initialized) {
            this.wheelLayout.setData(data);
        }
    }

    public void setDefaultValue(Object item) {
        this.defaultValue = item;
        if (this.initialized) {
            this.wheelLayout.setDefaultValue(item);
        }
    }

    public void setDefaultPosition(int position) {
        this.defaultPosition = position;
        if (this.initialized) {
            this.wheelLayout.setDefaultPosition(position);
        }
    }

    public void setOnOptionPickedListener(OnOptionPickedListener onOptionPickedListener) {
        this.onOptionPickedListener = onOptionPickedListener;
    }

    public final OptionWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }

    public final WheelView getWheelView() {
        return this.wheelLayout.getWheelView();
    }

    public final TextView getLabelView() {
        return this.wheelLayout.getLabelView();
    }
}

