/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.impl;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.github.gzuliyujiang.wheelpicker.contract.AddressLoader;
import com.github.gzuliyujiang.wheelpicker.contract.AddressReceiver;
import com.github.gzuliyujiang.wheelpicker.entity.ProvinceEntity;
import com.github.gzuliyujiang.wheelpicker.utility.AddressParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;

public class AssetsAddressLoader
implements AddressLoader {
    private final Context context;
    private final String path;

    public AssetsAddressLoader(@NonNull Context context, @NonNull String path) {
        this.context = context;
        this.path = path;
    }

    @Override
    public void loadJson(final @NonNull AddressReceiver receiver) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final List data = AssetsAddressLoader.this.loadFromAssets();
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        receiver.onAddressReceived(data);
                    }
                });
            }
        });
    }

    @WorkerThread
    private List<ProvinceEntity> loadFromAssets() {
        StringBuilder stringBuilder = new StringBuilder();
        AssetManager am = this.context.getAssets();
        try (BufferedReader bf = new BufferedReader(new InputStreamReader(am.open(this.path)));){
            String line;
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            return new ArrayList<ProvinceEntity>();
        }
        String json = stringBuilder.toString();
        try {
            return AddressParser.parseData(json);
        }
        catch (Exception e) {
            return new ArrayList<ProvinceEntity>();
        }
    }
}

