/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class DoublePicker
extends WheelPicker {
    private List<String> firstData = new ArrayList<String>();
    private List<String> secondData = new ArrayList<String>();
    private int selectedFirstIndex = 0;
    private int selectedSecondIndex = 0;
    private OnWheelListener onWheelListener;
    private OnPickListener onPickListener;

    public DoublePicker(Activity activity, List<String> firstData, List<String> secondData) {
        super(activity);
        this.firstData = firstData;
        this.secondData = secondData;
    }

    public void setSelectedIndex(int firstIndex, int secondIndex) {
        if (firstIndex >= 0 && firstIndex < this.firstData.size()) {
            this.selectedFirstIndex = firstIndex;
        }
        if (secondIndex >= 0 && secondIndex < this.secondData.size()) {
            this.selectedSecondIndex = secondIndex;
        }
    }

    public String getSelectedFirstItem() {
        if (this.firstData.size() > this.selectedFirstIndex) {
            return this.firstData.get(this.selectedFirstIndex);
        }
        return "";
    }

    public String getSelectedSecondItem() {
        if (this.secondData.size() > this.selectedSecondIndex) {
            return this.secondData.get(this.selectedSecondIndex);
        }
        return "";
    }

    @NonNull
    protected View makeCenterView() {
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView firstView = this.createWheelView();
        firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        layout.addView((View)firstView);
        WheelView secondView = this.createWheelView();
        secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        layout.addView((View)secondView);
        firstView.setItems(this.firstData, this.selectedFirstIndex);
        firstView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                DoublePicker.this.selectedFirstIndex = index;
                if (DoublePicker.this.onWheelListener != null) {
                    DoublePicker.this.onWheelListener.onFirstWheeled(DoublePicker.this.selectedFirstIndex, (String)DoublePicker.this.firstData.get(DoublePicker.this.selectedFirstIndex));
                }
            }
        });
        secondView.setItems(this.secondData, this.selectedSecondIndex);
        secondView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                DoublePicker.this.selectedSecondIndex = index;
                if (DoublePicker.this.onWheelListener != null) {
                    DoublePicker.this.onWheelListener.onSecondWheeled(DoublePicker.this.selectedSecondIndex, (String)DoublePicker.this.secondData.get(DoublePicker.this.selectedSecondIndex));
                }
            }
        });
        return layout;
    }

    public void onSubmit() {
        if (this.onPickListener != null) {
            this.onPickListener.onPicked(this.selectedFirstIndex, this.selectedSecondIndex);
        }
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnPickListener(OnPickListener onPickListener) {
        this.onPickListener = onPickListener;
    }

    public static interface OnPickListener {
        public void onPicked(int var1, int var2);
    }

    public static interface OnWheelListener {
        public void onFirstWheeled(int var1, String var2);

        public void onSecondWheeled(int var1, String var2);
    }
}

