/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

public class DateTimePicker
extends WheelPicker {
    public static final int NONE = -1;
    public static final int YEAR_MONTH_DAY = 0;
    public static final int YEAR_MONTH = 1;
    public static final int MONTH_DAY = 2;
    public static final int HOUR_24 = 3;
    @Deprecated
    public static final int HOUR_OF_DAY = 3;
    public static final int HOUR_12 = 4;
    @Deprecated
    public static final int HOUR = 4;
    private ArrayList<String> years = new ArrayList();
    private ArrayList<String> months = new ArrayList();
    private ArrayList<String> days = new ArrayList();
    private ArrayList<String> hours = new ArrayList();
    private ArrayList<String> minutes = new ArrayList();
    private String yearLabel = "\u5e74";
    private String monthLabel = "\u6708";
    private String dayLabel = "\u65e5";
    private String hourLabel = "\u65f6";
    private String minuteLabel = "\u5206";
    private int selectedYearIndex = 0;
    private int selectedMonthIndex = 0;
    private int selectedDayIndex = 0;
    private String selectedHour = "";
    private String selectedMinute = "";
    private OnWheelListener onWheelListener;
    private OnDateTimePickListener onDateTimePickListener;
    private int dateMode = 0;
    private int timeMode = 3;
    private int startYear = 2010;
    private int startMonth = 1;
    private int startDay = 1;
    private int endYear = 2020;
    private int endMonth = 12;
    private int endDay = 31;
    private int startHour;
    private int startMinute = 0;
    private int endHour;
    private int endMinute = 59;
    private int textSize = 16;
    private boolean useWeight = false;

    public DateTimePicker(Activity activity, int timeMode) {
        this(activity, 0, timeMode);
    }

    public DateTimePicker(Activity activity, int dateMode, int timeMode) {
        super(activity);
        if (dateMode == -1 && timeMode == -1) {
            throw new IllegalArgumentException("The modes are NONE at the same time");
        }
        if (dateMode == 0 && timeMode != -1) {
            if (this.screenWidthPixels < 720) {
                this.textSize = 14;
            } else if (this.screenWidthPixels < 480) {
                this.textSize = 12;
            }
        }
        this.dateMode = dateMode;
        if (timeMode == 4) {
            this.startHour = 1;
            this.endHour = 12;
        } else {
            this.startHour = 0;
            this.endHour = 23;
        }
        this.timeMode = timeMode;
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    @Deprecated
    public void setRange(int startYear, int endYear) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        this.startYear = startYear;
        this.endYear = endYear;
        this.initYearData();
    }

    public void setDateRangeStart(int startYear, int startMonth, int startDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        this.startYear = startYear;
        this.startMonth = startMonth;
        this.startDay = startDay;
    }

    public void setDateRangeEnd(int endYear, int endMonth, int endDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        this.endYear = endYear;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.initYearData();
    }

    public void setDateRangeStart(int startYearOrMonth, int startMonthOrDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        if (this.dateMode == 0) {
            throw new IllegalArgumentException("Not support year/month/day mode");
        }
        if (this.dateMode == 1) {
            this.startYear = startYearOrMonth;
            this.startMonth = startMonthOrDay;
        } else if (this.dateMode == 2) {
            int year;
            this.startYear = this.endYear = (year = Calendar.getInstance(Locale.CHINA).get(1));
            this.startMonth = startYearOrMonth;
            this.startDay = startMonthOrDay;
        }
    }

    public void setDateRangeEnd(int endYearOrMonth, int endMonthOrDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        if (this.dateMode == 0) {
            throw new IllegalArgumentException("Not support year/month/day mode");
        }
        if (this.dateMode == 1) {
            this.endYear = endYearOrMonth;
            this.endMonth = endMonthOrDay;
        } else if (this.dateMode == 2) {
            this.endMonth = endYearOrMonth;
            this.endDay = endMonthOrDay;
        }
        this.initYearData();
    }

    public void setTimeRangeStart(int startHour, int startMinute) {
        if (this.timeMode == -1) {
            throw new IllegalArgumentException("Time mode invalid");
        }
        boolean illegal = false;
        if (startHour < 0 || startMinute < 0 || startMinute > 59) {
            illegal = true;
        }
        if (this.timeMode == 4 && (startHour == 0 || startHour > 12)) {
            illegal = true;
        }
        if (this.timeMode == 3 && startHour >= 24) {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("Time out of range");
        }
        this.startHour = startHour;
        this.startMinute = startMinute;
    }

    public void setTimeRangeEnd(int endHour, int endMinute) {
        if (this.timeMode == -1) {
            throw new IllegalArgumentException("Time mode invalid");
        }
        boolean illegal = false;
        if (endHour < 0 || endMinute < 0 || endMinute > 59) {
            illegal = true;
        }
        if (this.timeMode == 4 && (endHour == 0 || endHour > 12)) {
            illegal = true;
        }
        if (this.timeMode == 3 && endHour >= 24) {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("Time out of range");
        }
        this.endHour = endHour;
        this.endMinute = endMinute;
        this.initHourData();
    }

    public void setLabel(String yearLabel, String monthLabel, String dayLabel, String hourLabel, String minuteLabel) {
        this.yearLabel = yearLabel;
        this.monthLabel = monthLabel;
        this.dayLabel = dayLabel;
        this.hourLabel = hourLabel;
        this.minuteLabel = minuteLabel;
    }

    public void setSelectedItem(int year, int month, int day, int hour, int minute) {
        if (this.dateMode != 0) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        LogUtils.verbose((Object)((Object)this), (String)"change months and days while set selected");
        this.changeMonthData(year);
        this.changeDayData(year, month);
        this.selectedYearIndex = this.findItemIndex(this.years, year);
        this.selectedMonthIndex = this.findItemIndex(this.months, month);
        this.selectedDayIndex = this.findItemIndex(this.days, day);
        if (this.timeMode != -1) {
            this.selectedHour = DateUtils.fillZero((int)hour);
            this.selectedMinute = DateUtils.fillZero((int)minute);
        }
    }

    public void setSelectedItem(int yearOrMonth, int monthOrDay, int hour, int minute) {
        if (this.dateMode == 0) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        if (this.dateMode == 2) {
            int year;
            LogUtils.verbose((Object)((Object)this), (String)"change months and days while set selected");
            this.startYear = this.endYear = (year = Calendar.getInstance(Locale.CHINA).get(1));
            this.changeMonthData(year);
            this.changeDayData(year, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, yearOrMonth);
            this.selectedDayIndex = this.findItemIndex(this.days, monthOrDay);
        } else if (this.dateMode == 1) {
            LogUtils.verbose((Object)((Object)this), (String)"change months while set selected");
            this.changeMonthData(yearOrMonth);
            this.selectedYearIndex = this.findItemIndex(this.years, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, monthOrDay);
        }
        if (this.timeMode != -1) {
            this.selectedHour = DateUtils.fillZero((int)hour);
            this.selectedMinute = DateUtils.fillZero((int)minute);
        }
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnDateTimePickListener(OnDateTimePickListener listener) {
        this.onDateTimePickListener = listener;
    }

    public String getSelectedYear() {
        if (this.dateMode == 0 || this.dateMode == 1) {
            if (this.years.size() <= this.selectedYearIndex) {
                this.selectedYearIndex = this.years.size() - 1;
            }
            return this.years.get(this.selectedYearIndex);
        }
        return "";
    }

    public String getSelectedMonth() {
        if (this.dateMode != -1) {
            if (this.months.size() <= this.selectedMonthIndex) {
                this.selectedMonthIndex = this.months.size() - 1;
            }
            return this.months.get(this.selectedMonthIndex);
        }
        return "";
    }

    public String getSelectedDay() {
        if (this.dateMode == 0 || this.dateMode == 2) {
            if (this.days.size() <= this.selectedDayIndex) {
                this.selectedDayIndex = this.days.size() - 1;
            }
            return this.days.get(this.selectedDayIndex);
        }
        return "";
    }

    public String getSelectedHour() {
        if (this.timeMode != -1) {
            return this.selectedHour;
        }
        return "";
    }

    public String getSelectedMinute() {
        if (this.timeMode != -1) {
            return this.selectedMinute;
        }
        return "";
    }

    @NonNull
    protected View makeCenterView() {
        TextView labelView;
        int selectedYear;
        if ((this.dateMode == 0 || this.dateMode == 1) && this.years.size() == 0) {
            LogUtils.verbose((Object)((Object)this), (String)"init years before make view");
            this.initYearData();
        }
        if (this.dateMode != -1 && this.months.size() == 0) {
            LogUtils.verbose((Object)((Object)this), (String)"init months before make view");
            selectedYear = DateUtils.trimZero((String)this.getSelectedYear());
            this.changeMonthData(selectedYear);
        }
        if ((this.dateMode == 0 || this.dateMode == 2) && this.days.size() == 0) {
            LogUtils.verbose((Object)((Object)this), (String)"init days before make view");
            selectedYear = this.dateMode == 0 ? DateUtils.trimZero((String)this.getSelectedYear()) : Calendar.getInstance(Locale.CHINA).get(1);
            int selectedMonth = DateUtils.trimZero((String)this.getSelectedMonth());
            this.changeDayData(selectedYear, selectedMonth);
        }
        if (this.timeMode != -1 && this.hours.size() == 0) {
            LogUtils.verbose((Object)((Object)this), (String)"init hours before make view");
            this.initHourData();
        }
        if (this.timeMode != -1 && this.minutes.size() == 0) {
            LogUtils.verbose((Object)((Object)this), (String)"init minutes before make view");
            this.changeMinuteData(DateUtils.trimZero((String)this.selectedHour));
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView yearView = this.createWheelView();
        final WheelView monthView = this.createWheelView();
        final WheelView dayView = this.createWheelView();
        WheelView hourView = this.createWheelView();
        final WheelView minuteView = this.createWheelView();
        yearView.setTextSize(this.textSize);
        monthView.setTextSize(this.textSize);
        dayView.setTextSize(this.textSize);
        hourView.setTextSize(this.textSize);
        minuteView.setTextSize(this.textSize);
        yearView.setUseWeight(this.useWeight);
        monthView.setUseWeight(this.useWeight);
        dayView.setUseWeight(this.useWeight);
        hourView.setUseWeight(this.useWeight);
        minuteView.setUseWeight(this.useWeight);
        if (this.dateMode == 0 || this.dateMode == 1) {
            yearView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            yearView.setItems(this.years, this.selectedYearIndex);
            yearView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

                @Override
                public void onSelected(int index) {
                    DateTimePicker.this.selectedYearIndex = index;
                    String selectedYearStr = (String)DateTimePicker.this.years.get(DateTimePicker.this.selectedYearIndex);
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onYearWheeled(DateTimePicker.this.selectedYearIndex, selectedYearStr);
                    }
                    LogUtils.verbose((Object)this, (String)"change months after year wheeled");
                    DateTimePicker.this.selectedMonthIndex = 0;
                    DateTimePicker.this.selectedDayIndex = 0;
                    int selectedYear = DateUtils.trimZero((String)selectedYearStr);
                    DateTimePicker.this.changeMonthData(selectedYear);
                    monthView.setItems(DateTimePicker.this.months, DateTimePicker.this.selectedMonthIndex);
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onMonthWheeled(DateTimePicker.this.selectedMonthIndex, (String)DateTimePicker.this.months.get(DateTimePicker.this.selectedMonthIndex));
                    }
                    DateTimePicker.this.changeDayData(selectedYear, DateUtils.trimZero((String)((String)DateTimePicker.this.months.get(DateTimePicker.this.selectedMonthIndex))));
                    dayView.setItems(DateTimePicker.this.days, DateTimePicker.this.selectedDayIndex);
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onDayWheeled(DateTimePicker.this.selectedDayIndex, (String)DateTimePicker.this.days.get(DateTimePicker.this.selectedDayIndex));
                    }
                }
            });
            layout.addView((View)yearView);
            if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
                labelView = this.createLabelView();
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.yearLabel);
                layout.addView((View)labelView);
            }
        }
        if (this.dateMode != -1) {
            monthView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            monthView.setItems(this.months, this.selectedMonthIndex);
            monthView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

                @Override
                public void onSelected(int index) {
                    DateTimePicker.this.selectedMonthIndex = index;
                    String selectedMonthStr = (String)DateTimePicker.this.months.get(DateTimePicker.this.selectedMonthIndex);
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onMonthWheeled(DateTimePicker.this.selectedMonthIndex, selectedMonthStr);
                    }
                    if (DateTimePicker.this.dateMode == 0 || DateTimePicker.this.dateMode == 2) {
                        LogUtils.verbose((Object)this, (String)"change days after month wheeled");
                        DateTimePicker.this.selectedDayIndex = 0;
                        int selectedYear = DateTimePicker.this.dateMode == 0 ? DateUtils.trimZero((String)DateTimePicker.this.getSelectedYear()) : Calendar.getInstance(Locale.CHINA).get(1);
                        DateTimePicker.this.changeDayData(selectedYear, DateUtils.trimZero((String)selectedMonthStr));
                        dayView.setItems(DateTimePicker.this.days, DateTimePicker.this.selectedDayIndex);
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onDayWheeled(DateTimePicker.this.selectedDayIndex, (String)DateTimePicker.this.days.get(DateTimePicker.this.selectedDayIndex));
                        }
                    }
                }
            });
            layout.addView((View)monthView);
            if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
                labelView = this.createLabelView();
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.monthLabel);
                layout.addView((View)labelView);
            }
        }
        if (this.dateMode == 0 || this.dateMode == 2) {
            dayView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            dayView.setItems(this.days, this.selectedDayIndex);
            dayView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

                @Override
                public void onSelected(int index) {
                    DateTimePicker.this.selectedDayIndex = index;
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onDayWheeled(DateTimePicker.this.selectedDayIndex, (String)DateTimePicker.this.days.get(DateTimePicker.this.selectedDayIndex));
                    }
                }
            });
            layout.addView((View)dayView);
            if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
                labelView = this.createLabelView();
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.dayLabel);
                layout.addView((View)labelView);
            }
        }
        if (this.timeMode != -1) {
            hourView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            hourView.setItems(this.hours, this.selectedHour);
            hourView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

                @Override
                public void onSelected(int index) {
                    DateTimePicker.this.selectedHour = (String)DateTimePicker.this.hours.get(index);
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onHourWheeled(index, DateTimePicker.this.selectedHour);
                    }
                    LogUtils.verbose((Object)this, (String)"change minutes after hour wheeled");
                    DateTimePicker.this.changeMinuteData(DateUtils.trimZero((String)DateTimePicker.this.selectedHour));
                    minuteView.setItems(DateTimePicker.this.minutes, DateTimePicker.this.selectedMinute);
                }
            });
            layout.addView((View)hourView);
            if (!TextUtils.isEmpty((CharSequence)this.hourLabel)) {
                labelView = this.createLabelView();
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.hourLabel);
                layout.addView((View)labelView);
            }
            minuteView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            minuteView.setItems(this.minutes, this.selectedMinute);
            minuteView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

                @Override
                public void onSelected(int index) {
                    DateTimePicker.this.selectedMinute = (String)DateTimePicker.this.minutes.get(index);
                    if (DateTimePicker.this.onWheelListener != null) {
                        DateTimePicker.this.onWheelListener.onMinuteWheeled(index, DateTimePicker.this.selectedMinute);
                    }
                }
            });
            layout.addView((View)minuteView);
            if (!TextUtils.isEmpty((CharSequence)this.minuteLabel)) {
                labelView = this.createLabelView();
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.minuteLabel);
                layout.addView((View)labelView);
            }
        }
        return layout;
    }

    protected void onSubmit() {
        if (this.onDateTimePickListener == null) {
            return;
        }
        String year = this.getSelectedYear();
        String month = this.getSelectedMonth();
        String day = this.getSelectedDay();
        String hour = this.getSelectedHour();
        String minute = this.getSelectedMinute();
        switch (this.dateMode) {
            case 0: {
                ((OnYearMonthDayTimePickListener)this.onDateTimePickListener).onDateTimePicked(year, month, day, hour, minute);
                break;
            }
            case 1: {
                ((OnYearMonthTimePickListener)this.onDateTimePickListener).onDateTimePicked(year, month, hour, minute);
                break;
            }
            case 2: {
                ((OnMonthDayTimePickListener)this.onDateTimePickListener).onDateTimePicked(month, day, hour, minute);
                break;
            }
            case -1: {
                ((OnTimePickListener)this.onDateTimePickListener).onDateTimePicked(hour, minute);
            }
        }
    }

    private int findItemIndex(ArrayList<String> items, int item) {
        int index = Collections.binarySearch(items, item, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                String lhsStr = lhs.toString();
                String rhsStr = rhs.toString();
                lhsStr = lhsStr.startsWith("0") ? lhsStr.substring(1) : lhsStr;
                rhsStr = rhsStr.startsWith("0") ? rhsStr.substring(1) : rhsStr;
                return Integer.parseInt(lhsStr) - Integer.parseInt(rhsStr);
            }
        });
        if (index < 0) {
            throw new IllegalArgumentException("Item[" + item + "] out of range");
        }
        return index;
    }

    private void initYearData() {
        this.years.clear();
        if (this.startYear == this.endYear) {
            this.years.add(String.valueOf(this.startYear));
        } else if (this.startYear < this.endYear) {
            for (int i = this.startYear; i <= this.endYear; ++i) {
                this.years.add(String.valueOf(i));
            }
        } else {
            for (int i = this.startYear; i >= this.endYear; --i) {
                this.years.add(String.valueOf(i));
            }
        }
    }

    private void changeMonthData(int selectedYear) {
        this.months.clear();
        if (this.startMonth < 1 || this.endMonth < 1 || this.startMonth > 12 || this.endMonth > 12) {
            throw new IllegalArgumentException("Month out of range [1-12]");
        }
        if (this.startYear == this.endYear) {
            if (this.startMonth > this.endMonth) {
                for (int i = this.endMonth; i >= this.startMonth; --i) {
                    this.months.add(DateUtils.fillZero((int)i));
                }
            } else {
                for (int i = this.startMonth; i <= this.endMonth; ++i) {
                    this.months.add(DateUtils.fillZero((int)i));
                }
            }
        } else if (selectedYear == this.startYear) {
            for (int i = this.startMonth; i <= 12; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        } else if (selectedYear == this.endYear) {
            for (int i = 1; i <= this.endMonth; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        } else {
            for (int i = 1; i <= 12; ++i) {
                this.months.add(DateUtils.fillZero((int)i));
            }
        }
    }

    private void changeDayData(int selectedYear, int selectedMonth) {
        int maxDays = DateUtils.calculateDaysInMonth((int)selectedYear, (int)selectedMonth);
        this.days.clear();
        if (selectedYear == this.startYear && selectedMonth == this.startMonth && selectedYear == this.endYear && selectedMonth == this.endMonth) {
            for (int i = this.startDay; i <= this.endDay; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
        } else if (selectedYear == this.startYear && selectedMonth == this.startMonth) {
            for (int i = this.startDay; i <= maxDays; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
        } else if (selectedYear == this.endYear && selectedMonth == this.endMonth) {
            for (int i = 1; i <= this.endDay; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
        } else {
            for (int i = 1; i <= maxDays; ++i) {
                this.days.add(DateUtils.fillZero((int)i));
            }
        }
    }

    private void initHourData() {
        for (int i = this.startHour; i <= this.endHour; ++i) {
            String hour = DateUtils.fillZero((int)i);
            this.hours.add(hour);
        }
        if (this.hours.indexOf(this.selectedHour) == -1) {
            this.selectedHour = this.hours.get(0);
        }
    }

    private void changeMinuteData(int selectedHour) {
        if (this.startHour == this.endHour) {
            if (this.startMinute > this.endMinute) {
                int temp = this.startMinute;
                this.startMinute = this.endMinute;
                this.endMinute = temp;
            }
            for (int i = this.startMinute; i <= this.endMinute; ++i) {
                this.minutes.add(DateUtils.fillZero((int)i));
            }
        } else if (selectedHour == this.startHour) {
            for (int i = this.startMinute; i <= 59; ++i) {
                this.minutes.add(DateUtils.fillZero((int)i));
            }
        } else if (selectedHour == this.endHour) {
            for (int i = 0; i <= this.endMinute; ++i) {
                this.minutes.add(DateUtils.fillZero((int)i));
            }
        } else {
            for (int i = 0; i <= 59; ++i) {
                this.minutes.add(DateUtils.fillZero((int)i));
            }
        }
        if (this.minutes.indexOf(this.selectedMinute) == -1) {
            this.selectedMinute = this.minutes.get(0);
        }
    }

    public static interface OnTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2);
    }

    @Deprecated
    public static interface OnMonthDayPickListener
    extends OnMonthDayTimePickListener {
    }

    public static interface OnMonthDayTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4);
    }

    @Deprecated
    public static interface OnYearMonthPickListener
    extends OnYearMonthTimePickListener {
    }

    public static interface OnYearMonthTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4);
    }

    public static interface OnYearMonthDayTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4, String var5);
    }

    protected static interface OnDateTimePickListener {
    }

    public static interface OnWheelListener {
        public void onYearWheeled(int var1, String var2);

        public void onMonthWheeled(int var1, String var2);

        public void onDayWheeled(int var1, String var2);

        public void onHourWheeled(int var1, String var2);

        public void onMinuteWheeled(int var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DateMode {
    }
}

