/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.entity.City;
import cn.qqtheme.framework.entity.County;
import cn.qqtheme.framework.entity.LinkageSecond;
import cn.qqtheme.framework.entity.Province;
import cn.qqtheme.framework.picker.LinkagePicker;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class AddressPicker
extends LinkagePicker<Province, City, County> {
    private OnAddressPickListener onAddressPickListener;
    private OnWheelListener onWheelListener;
    private boolean hideProvince = false;
    private boolean hideCounty = false;
    private ArrayList<Province> provinces = new ArrayList();

    public AddressPicker(Activity activity, ArrayList<Province> provinces) {
        super(activity, new AddressProvider(provinces));
        this.provinces = provinces;
    }

    @Override
    public void setSelectedItem(Province province, City city, County county) {
        super.setSelectedItem(province, city, county);
    }

    @Override
    public void setSelectedItem(String province, String city, String county) {
        this.setSelectedItem(new Province(province), new City(city), new County(county));
    }

    public Province getSelectedProvince() {
        return this.provinces.get(this.selectedFirstIndex);
    }

    public City getSelectedCity() {
        List<City> cities = this.getSelectedProvince().getCities();
        if (cities.size() == 0) {
            return null;
        }
        return cities.get(this.selectedSecondIndex);
    }

    public County getSelectedCounty() {
        List<County> counties = this.getSelectedCity().getCounties();
        if (counties.size() == 0) {
            return null;
        }
        return counties.get(this.selectedThirdIndex);
    }

    public void setHideProvince(boolean hideProvince) {
        this.hideProvince = hideProvince;
    }

    public void setHideCounty(boolean hideCounty) {
        this.hideCounty = hideCounty;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnAddressPickListener(OnAddressPickListener listener) {
        this.onAddressPickListener = listener;
    }

    @Override
    @Deprecated
    public final void setOnLinkageListener(LinkagePicker.OnLinkageListener onLinkageListener) {
        throw new UnsupportedOperationException("Please use setOnAddressPickListener instead.");
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set address provider before make view");
        }
        float provinceWeight = this.firstColumnWeight;
        float cityWeight = this.secondColumnWeight;
        float countyWeight = this.thirdColumnWeight;
        if (this.hideCounty) {
            this.hideProvince = false;
        }
        if (this.hideProvince) {
            provinceWeight = 0.0f;
            cityWeight = this.firstColumnWeight;
            countyWeight = this.secondColumnWeight;
        }
        this.dividerConfig.setRatio(0.0f);
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView provinceView = new WheelView((Context)this.activity);
        provinceView.setUseWeight(true);
        provinceView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, provinceWeight));
        provinceView.setTextSize(this.textSize);
        provinceView.setTextColor(this.textColorNormal, this.textColorFocus);
        provinceView.setDividerConfig(this.dividerConfig);
        provinceView.setOffset(this.offset);
        provinceView.setCycleDisable(this.cycleDisable);
        layout.addView((View)provinceView);
        if (this.hideProvince) {
            provinceView.setVisibility(8);
        }
        final WheelView cityView = new WheelView((Context)this.activity);
        cityView.setUseWeight(true);
        cityView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, cityWeight));
        cityView.setTextSize(this.textSize);
        cityView.setTextColor(this.textColorNormal, this.textColorFocus);
        cityView.setDividerConfig(this.dividerConfig);
        cityView.setOffset(this.offset);
        cityView.setCycleDisable(this.cycleDisable);
        layout.addView((View)cityView);
        final WheelView countyView = new WheelView((Context)this.activity);
        countyView.setUseWeight(true);
        countyView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, countyWeight));
        countyView.setTextSize(this.textSize);
        countyView.setTextColor(this.textColorNormal, this.textColorFocus);
        countyView.setDividerConfig(this.dividerConfig);
        countyView.setOffset(this.offset);
        countyView.setCycleDisable(this.cycleDisable);
        layout.addView((View)countyView);
        if (this.hideCounty) {
            countyView.setVisibility(8);
        }
        provinceView.setItems(this.provider.initFirstData(), this.selectedFirstIndex);
        provinceView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                AddressPicker.this.selectedFirstIndex = index;
                AddressPicker.this.selectedFirstItem = AddressPicker.this.getSelectedProvince();
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onProvinceWheeled(AddressPicker.this.selectedFirstIndex, (Province)AddressPicker.this.selectedFirstItem);
                }
                LogUtils.verbose((Object)this, (String)("change cities after province wheeled: index=" + index));
                AddressPicker.this.selectedSecondIndex = 0;
                AddressPicker.this.selectedThirdIndex = 0;
                List cities = AddressPicker.this.provider.linkageSecondData(AddressPicker.this.selectedFirstIndex);
                if (cities.size() > 0) {
                    AddressPicker.this.selectedSecondItem = (LinkageSecond)cities.get(AddressPicker.this.selectedSecondIndex);
                    cityView.setItems(cities, AddressPicker.this.selectedSecondIndex);
                } else {
                    AddressPicker.this.selectedSecondItem = null;
                    cityView.setItems(new ArrayList());
                }
                List counties = AddressPicker.this.provider.linkageThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                if (counties.size() > 0) {
                    AddressPicker.this.selectedThirdItem = counties.get(AddressPicker.this.selectedThirdIndex);
                    countyView.setItems(counties, AddressPicker.this.selectedThirdIndex);
                } else {
                    AddressPicker.this.selectedThirdItem = null;
                    countyView.setItems(new ArrayList());
                }
            }
        });
        cityView.setItems(this.provider.linkageSecondData(this.selectedFirstIndex), this.selectedSecondIndex);
        cityView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                AddressPicker.this.selectedSecondIndex = index;
                AddressPicker.this.selectedSecondItem = AddressPicker.this.getSelectedCity();
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onCityWheeled(AddressPicker.this.selectedSecondIndex, (City)AddressPicker.this.selectedSecondItem);
                }
                LogUtils.verbose((Object)this, (String)("change counties after city wheeled: index=" + index));
                AddressPicker.this.selectedThirdIndex = 0;
                List counties = AddressPicker.this.provider.linkageThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                if (counties.size() > 0) {
                    AddressPicker.this.selectedThirdItem = counties.get(AddressPicker.this.selectedThirdIndex);
                    countyView.setItems(counties, AddressPicker.this.selectedThirdIndex);
                } else {
                    AddressPicker.this.selectedThirdItem = null;
                    countyView.setItems(new ArrayList());
                }
            }
        });
        countyView.setItems(this.provider.linkageThirdData(this.selectedFirstIndex, this.selectedSecondIndex), this.selectedThirdIndex);
        countyView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                AddressPicker.this.selectedThirdIndex = index;
                AddressPicker.this.selectedThirdItem = AddressPicker.this.getSelectedCounty();
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onCountyWheeled(AddressPicker.this.selectedThirdIndex, (County)AddressPicker.this.selectedThirdItem);
                }
            }
        });
        return layout;
    }

    @Override
    public void onSubmit() {
        if (this.onAddressPickListener != null) {
            Province province = this.getSelectedProvince();
            City city = this.getSelectedCity();
            County county = null;
            if (!this.hideCounty) {
                county = this.getSelectedCounty();
            }
            this.onAddressPickListener.onAddressPicked(province, city, county);
        }
    }

    private static class AddressProvider
    implements LinkagePicker.Provider<Province, City, County> {
        private List<Province> firstList = new ArrayList<Province>();
        private List<List<City>> secondList = new ArrayList<List<City>>();
        private List<List<List<County>>> thirdList = new ArrayList<List<List<County>>>();

        public AddressProvider(List<Province> provinces) {
            this.parseData(provinces);
        }

        @Override
        public boolean isOnlyTwo() {
            return this.thirdList.size() == 0;
        }

        @Override
        @NonNull
        public List<Province> initFirstData() {
            return this.firstList;
        }

        @Override
        @NonNull
        public List<City> linkageSecondData(int firstIndex) {
            return this.secondList.get(firstIndex);
        }

        @Override
        @NonNull
        public List<County> linkageThirdData(int firstIndex, int secondIndex) {
            return this.thirdList.get(firstIndex).get(secondIndex);
        }

        private void parseData(List<Province> data) {
            int provinceSize = data.size();
            for (int x = 0; x < provinceSize; ++x) {
                Province pro = data.get(x);
                this.firstList.add(pro);
                List<City> cities = pro.getCities();
                ArrayList<City> xCities = new ArrayList<City>();
                ArrayList xCounties = new ArrayList();
                int citySize = cities.size();
                for (int y = 0; y < citySize; ++y) {
                    City cit = cities.get(y);
                    cit.setProvinceId(pro.getAreaId());
                    xCities.add(cit);
                    List<County> counties = cit.getCounties();
                    ArrayList<County> yCounties = new ArrayList<County>();
                    int countySize = counties.size();
                    for (int z = 0; z < countySize; ++z) {
                        County cou = counties.get(z);
                        cou.setCityId(cit.getAreaId());
                        yCounties.add(cou);
                    }
                    xCounties.add(yCounties);
                }
                this.secondList.add(xCities);
                this.thirdList.add(xCounties);
            }
        }
    }

    public static interface OnWheelListener {
        public void onProvinceWheeled(int var1, Province var2);

        public void onCityWheeled(int var1, City var2);

        public void onCountyWheeled(int var1, County var2);
    }

    public static interface OnAddressPickListener {
        public void onAddressPicked(Province var1, City var2, County var3);
    }
}

