/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import cn.qqtheme.framework.util.LogUtils;
import java.util.LinkedList;
import java.util.List;

public class WheelView
extends ScrollView {
    public static final int TEXT_SIZE = 20;
    public static final int TEXT_COLOR_FOCUS = -16611122;
    public static final int TEXT_COLOR_NORMAL = -4473925;
    public static final int LINE_COLOR = -8139290;
    public static final int OFF_SET = 1;
    private static final int DELAY = 50;
    private Context context;
    private LinearLayout views;
    private LinkedList<String> items = new LinkedList();
    private int offset = 1;
    private int displayItemCount;
    private int selectedIndex = 1;
    private int initialY;
    private Runnable scrollerTask = new ScrollerTask();
    private int itemHeight = 0;
    private int[] selectedAreaBorder;
    private OnWheelListener onWheelListener;
    private Paint paint;
    private int viewWidth;
    private int textSize = 20;
    private int textColorNormal = -4473925;
    private int textColorFocus = -16611122;
    private int lineColor = -8139290;
    private boolean lineVisible = true;
    private boolean isUserScroll = false;
    private boolean cycleDisable = false;
    private float previousY = 0.0f;

    public WheelView(Context context) {
        super(context);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.setFadingEdgeLength(0);
        if (Build.VERSION.SDK_INT >= 9) {
            this.setOverScrollMode(2);
        }
        this.setVerticalScrollBarEnabled(false);
        this.views = new LinearLayout(context);
        this.views.setOrientation(1);
        this.addView((View)this.views);
    }

    private void startScrollerTask() {
        this.initialY = this.getScrollY();
        this.postDelayed(this.scrollerTask, 50L);
    }

    private void initData() {
        this.displayItemCount = this.offset * 2 + 1;
        this.views.removeAllViews();
        for (String item : this.items) {
            this.views.addView((View)this.createView(item));
        }
        this.refreshItemView(this.itemHeight * (this.selectedIndex - this.offset));
    }

    private TextView createView(String item) {
        TextView tv = new TextView(this.context);
        tv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        tv.setSingleLine(true);
        tv.setEllipsize(TextUtils.TruncateAt.END);
        tv.setText((CharSequence)item);
        tv.setTextSize((float)this.textSize);
        tv.setGravity(17);
        int padding = this.dip2px(15.0f);
        tv.setPadding(padding, padding, padding, padding);
        if (0 == this.itemHeight) {
            this.itemHeight = this.getViewMeasuredHeight((View)tv);
            LogUtils.verbose((Object)((Object)this), (String)("itemHeight: " + this.itemHeight));
            this.views.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.itemHeight * this.displayItemCount));
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getLayoutParams();
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(lp.width, this.itemHeight * this.displayItemCount));
        }
        return tv;
    }

    private void refreshItemView(int y) {
        int position = y / this.itemHeight + this.offset;
        int remainder = y % this.itemHeight;
        int divided = y / this.itemHeight;
        if (remainder == 0) {
            position = divided + this.offset;
        } else if (remainder > this.itemHeight / 2) {
            position = divided + this.offset + 1;
        }
        LogUtils.verbose((String)("current scroll position : " + position));
        int childSize = this.views.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            TextView itemView = (TextView)this.views.getChildAt(i);
            if (null == itemView) {
                return;
            }
            if (position == i) {
                itemView.setTextColor(this.textColorFocus);
                continue;
            }
            itemView.setTextColor(this.textColorNormal);
        }
    }

    private void onSelectedCallBack() {
        if (null != this.onWheelListener) {
            int realIndex = this.selectedIndex - this.offset;
            LogUtils.verbose((String)("isUserScroll=" + this.isUserScroll + ",selectedIndex=" + this.selectedIndex + ",realIndex=" + realIndex));
            this.onWheelListener.onSelected(this.isUserScroll, realIndex, this.items.get(this.selectedIndex));
        }
    }

    private int dip2px(float dpValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private int getViewMeasuredHeight(View view) {
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        view.measure(width, expandSpec);
        return view.getMeasuredHeight();
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundDrawable(Drawable background) {
        super.setBackgroundDrawable((Drawable)new LineDrawable());
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        LogUtils.verbose((Object)((Object)this), (String)("horizontal scroll origin: " + l + ", vertical scroll origin: " + t));
        this.refreshItemView(t);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        LogUtils.verbose((Object)((Object)this), (String)("w: " + w + ", h: " + h + ", oldw: " + oldw + ", oldh: " + oldh));
        this.viewWidth = w;
        this.setBackgroundDrawable(null);
    }

    public void fling(int velocityY) {
        super.fling(velocityY / 3);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.isUserScroll = true;
        switch (ev.getAction()) {
            case 0: {
                this.previousY = ev.getY();
                break;
            }
            case 1: {
                LogUtils.verbose((Object)((Object)this), (String)String.format("items=%s, offset=%s", this.items.size(), this.offset));
                LogUtils.verbose((Object)((Object)this), (String)("selectedIndex=" + this.selectedIndex));
                if (this.cycleDisable) {
                    this.startScrollerTask();
                    break;
                }
                float delta = ev.getY() - this.previousY;
                LogUtils.verbose((Object)((Object)this), (String)("delta=" + delta));
                if (this.selectedIndex == this.offset && delta > 0.0f) {
                    this.setSelectedIndex(this.items.size() - this.offset * 2 - 1);
                    break;
                }
                if (this.selectedIndex == this.items.size() - this.offset - 1 && delta < 0.0f) {
                    this.setSelectedIndex(0);
                    break;
                }
                this.startScrollerTask();
            }
        }
        return super.onTouchEvent(ev);
    }

    private void _setItems(List<String> list) {
        this.items.clear();
        this.items.addAll(list);
        for (int i = 0; i < this.offset; ++i) {
            this.items.addFirst("");
            this.items.addLast("");
        }
        this.initData();
    }

    public void setItems(List<String> list) {
        this._setItems(list);
        this.setSelectedIndex(0);
    }

    public void setItems(List<String> list, int index) {
        this._setItems(list);
        this.setSelectedIndex(index);
    }

    public void setItems(List<String> list, String item) {
        this._setItems(list);
        this.setSelectedItem(item);
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getTextColor() {
        return this.textColorFocus;
    }

    public void setTextColor(@ColorInt int textColorNormal, @ColorInt int textColorFocus) {
        this.textColorNormal = textColorNormal;
        this.textColorFocus = textColorFocus;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean lineVisible) {
        this.lineVisible = lineVisible;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(@ColorInt int lineColor) {
        this.lineColor = lineColor;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(@IntRange(from=1L, to=4L) int offset) {
        if (offset < 1 || offset > 4) {
            throw new IllegalArgumentException("Offset must between 1 and 4");
        }
        this.offset = offset;
    }

    public void setCycleDisable(boolean cycleDisable) {
        this.cycleDisable = cycleDisable;
    }

    private void setSelectedIndex(final @IntRange(from=0L) int index) {
        this.isUserScroll = false;
        this.post(new Runnable(){

            @Override
            public void run() {
                WheelView.this.scrollTo(0, index * WheelView.this.itemHeight);
                WheelView.this.selectedIndex = index + WheelView.this.offset;
                WheelView.this.onSelectedCallBack();
                WheelView.this.refreshItemView(WheelView.this.itemHeight * index);
            }
        });
    }

    public void setSelectedItem(String item) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(item)) continue;
            this.setSelectedIndex(i - this.offset);
            break;
        }
    }

    public String getSelectedItem() {
        return this.items.get(this.selectedIndex);
    }

    public int getSelectedIndex() {
        return this.selectedIndex - this.offset;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    static /* synthetic */ int[] access$1402(WheelView x0, int[] x1) {
        x0.selectedAreaBorder = x1;
        return x1;
    }

    private class LineDrawable
    extends Drawable {
        LineDrawable() {
            if (WheelView.this.viewWidth == 0) {
                WheelView.this.viewWidth = ((Activity)WheelView.this.context).getWindowManager().getDefaultDisplay().getWidth();
                LogUtils.debug((Object)((Object)this), (String)("viewWidth: " + WheelView.this.viewWidth));
            }
            if (!WheelView.this.lineVisible) {
                return;
            }
            if (null == WheelView.this.paint) {
                WheelView.this.paint = new Paint();
                WheelView.this.paint.setColor(WheelView.this.lineColor);
                WheelView.this.paint.setStrokeWidth((float)WheelView.this.dip2px(1.0f));
            }
        }

        public void draw(@NonNull Canvas canvas) {
            if (!WheelView.this.lineVisible) {
                return;
            }
            if (null == WheelView.this.selectedAreaBorder) {
                WheelView.access$1402(WheelView.this, new int[2]);
                ((WheelView)WheelView.this).selectedAreaBorder[0] = WheelView.this.itemHeight * WheelView.this.offset;
                ((WheelView)WheelView.this).selectedAreaBorder[1] = WheelView.this.itemHeight * (WheelView.this.offset + 1);
            }
            canvas.drawLine((float)(WheelView.this.viewWidth / 6), (float)WheelView.this.selectedAreaBorder[0], (float)(WheelView.this.viewWidth * 5 / 6), (float)WheelView.this.selectedAreaBorder[0], WheelView.this.paint);
            canvas.drawLine((float)(WheelView.this.viewWidth / 6), (float)WheelView.this.selectedAreaBorder[1], (float)(WheelView.this.viewWidth * 5 / 6), (float)WheelView.this.selectedAreaBorder[1], WheelView.this.paint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }

    private class ScrollerTask
    implements Runnable {
        private ScrollerTask() {
        }

        @Override
        public void run() {
            if (WheelView.this.itemHeight == 0) {
                LogUtils.debug((Object)this, (String)"itemHeight is zero");
                return;
            }
            int newY = WheelView.this.getScrollY();
            if (WheelView.this.initialY - newY == 0) {
                final int remainder = WheelView.this.initialY % WheelView.this.itemHeight;
                final int divided = WheelView.this.initialY / WheelView.this.itemHeight;
                LogUtils.verbose((Object)this, (String)("initialY: " + WheelView.this.initialY + ", remainder: " + remainder + ", divided: " + divided));
                if (remainder == 0) {
                    WheelView.this.selectedIndex = divided + WheelView.this.offset;
                    WheelView.this.onSelectedCallBack();
                } else if (remainder > WheelView.this.itemHeight / 2) {
                    WheelView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder + WheelView.this.itemHeight);
                            WheelView.this.selectedIndex = divided + WheelView.this.offset + 1;
                            WheelView.this.onSelectedCallBack();
                        }
                    });
                } else {
                    WheelView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder);
                            WheelView.this.selectedIndex = divided + WheelView.this.offset;
                            WheelView.this.onSelectedCallBack();
                        }
                    });
                }
            } else {
                WheelView.this.startScrollerTask();
            }
        }
    }

    public static interface OnWheelListener {
        public void onSelected(boolean var1, int var2, String var3);
    }
}

