/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.filepicker.ExplorerConfig;
import com.github.gzuliyujiang.filepicker.adapter.FileEntity;
import com.github.gzuliyujiang.filepicker.adapter.ViewHolder;
import com.github.gzuliyujiang.filepicker.filter.SimpleFilter;
import com.github.gzuliyujiang.filepicker.sort.SortByExtension;
import com.github.gzuliyujiang.filepicker.sort.SortByName;
import com.github.gzuliyujiang.filepicker.sort.SortBySize;
import com.github.gzuliyujiang.filepicker.sort.SortByTime;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class FileAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private static final Handler UI_HANDLER = new Handler(Looper.getMainLooper());
    public static final String DIR_ROOT = ".";
    public static final String DIR_PARENT = "..";
    private final List<FileEntity> data = new ArrayList<FileEntity>();
    private File currentFile = null;
    private final ConcurrentLinkedQueue<FutureTask<?>> futureTasks = new ConcurrentLinkedQueue();
    private ExplorerConfig explorerConfig;

    public FileAdapter(ExplorerConfig explorerConfig) {
        this.explorerConfig = explorerConfig;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setOrientation(0);
        layout2.setGravity(16);
        int height = (int)((float)this.explorerConfig.getItemHeight() * context.getResources().getDisplayMetrics().density);
        int matchParent = -1;
        layout2.setLayoutParams(new ViewGroup.LayoutParams(matchParent, height));
        int padding = (int)(5.0f * context.getResources().getDisplayMetrics().density);
        layout2.setPadding(padding, padding, padding, padding);
        ImageView imageView = new ImageView(context);
        int size = (int)(20.0f * context.getResources().getDisplayMetrics().density);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(size, size));
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        imageView.setImageResource(17301579);
        layout2.addView((View)imageView);
        TextView textView = new TextView(context);
        LinearLayout.LayoutParams tvParams = new LinearLayout.LayoutParams(matchParent, matchParent);
        tvParams.leftMargin = (int)(10.0f * context.getResources().getDisplayMetrics().density);
        textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
        textView.setGravity(8388627);
        textView.setSingleLine();
        layout2.addView((View)textView);
        ViewHolder viewHolder = new ViewHolder((View)layout2);
        viewHolder.textView = textView;
        viewHolder.imageView = imageView;
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final int adapterPosition = holder.getAdapterPosition();
        final FileEntity item = this.getItem(adapterPosition);
        holder.imageView.setImageDrawable(item.getIcon());
        holder.textView.setText((CharSequence)item.getName());
        if (this.explorerConfig.getOnPathClickedListener() == null) {
            return;
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileAdapter.this.explorerConfig.getOnPathClickedListener().onPathClicked(FileAdapter.this, adapterPosition, item.getFile().getAbsolutePath());
            }
        });
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void setExplorerConfig(ExplorerConfig explorerConfig) {
        this.explorerConfig = explorerConfig;
        this.loadData(this.currentFile);
    }

    public ExplorerConfig getExplorerConfig() {
        return this.explorerConfig;
    }

    public final void recycleData() {
        Bitmap fileBitmap;
        Bitmap folderBitmap;
        Bitmap upBitmap;
        Bitmap homeBitmap;
        this.data.clear();
        if (this.explorerConfig.getHomeIcon() instanceof BitmapDrawable && null != (homeBitmap = ((BitmapDrawable)this.explorerConfig.getHomeIcon()).getBitmap()) && !homeBitmap.isRecycled()) {
            homeBitmap.recycle();
        }
        if (this.explorerConfig.getUpIcon() instanceof BitmapDrawable && null != (upBitmap = ((BitmapDrawable)this.explorerConfig.getUpIcon()).getBitmap()) && !upBitmap.isRecycled()) {
            upBitmap.recycle();
        }
        if (this.explorerConfig.getFolderIcon() instanceof BitmapDrawable && null != (folderBitmap = ((BitmapDrawable)this.explorerConfig.getFolderIcon()).getBitmap()) && !folderBitmap.isRecycled()) {
            folderBitmap.recycle();
        }
        if (this.explorerConfig.getFileIcon() instanceof BitmapDrawable && null != (fileBitmap = ((BitmapDrawable)this.explorerConfig.getFileIcon()).getBitmap()) && !fileBitmap.isRecycled()) {
            fileBitmap.recycle();
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public FileEntity getItem(int position) {
        return this.data.get(position);
    }

    public void loadData(final File dir) {
        if (!this.explorerConfig.isLoadAsync()) {
            this.reallyRefresh(this.loadDataSync(dir));
            return;
        }
        FutureTask<?> lastTask = this.futureTasks.peek();
        if (lastTask != null && !lastTask.isDone()) {
            lastTask.cancel(true);
        }
        FutureTask<Void> newTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() {
                final List temp = FileAdapter.this.loadDataSync(dir);
                FutureTask task = (FutureTask)FileAdapter.this.futureTasks.poll();
                if (task != null && task.isCancelled()) {
                    DialogLog.print((Object)("data load is canceled: " + FileAdapter.this.currentFile));
                    return null;
                }
                UI_HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        FileAdapter.this.reallyRefresh(temp);
                    }
                });
                return null;
            }
        });
        this.futureTasks.add(newTask);
        THREAD_POOL.execute(newTask);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void reallyRefresh(List<FileEntity> temp) {
        this.data.clear();
        this.data.addAll(temp);
        this.notifyDataSetChanged();
        if (this.explorerConfig.getOnFileLoadedListener() != null) {
            this.explorerConfig.getOnFileLoadedListener().onFileLoaded(this.currentFile);
        }
        DialogLog.print((Object)("notify changed when data loaded: " + this.currentFile));
    }

    private List<FileEntity> loadDataSync(File dir) {
        if (dir == null) {
            DialogLog.print((Object)"current directory is null");
            dir = this.explorerConfig.getRootDir();
        }
        long millis = System.currentTimeMillis();
        ArrayList<FileEntity> entities = new ArrayList<FileEntity>();
        DialogLog.print((Object)("will load directory: " + dir));
        this.currentFile = dir;
        if (this.explorerConfig.isShowHomeDir()) {
            FileEntity root = new FileEntity();
            root.setIcon(this.explorerConfig.getHomeIcon());
            root.setName(DIR_ROOT);
            root.setFile(this.explorerConfig.getRootDir());
            entities.add(root);
        }
        if (this.explorerConfig.isShowUpDir() && !File.separator.equals(dir.getAbsolutePath())) {
            FileEntity parent = new FileEntity();
            parent.setIcon(this.explorerConfig.getUpIcon());
            parent.setName(DIR_PARENT);
            parent.setFile(dir.getParentFile());
            entities.add(parent);
        }
        SimpleFilter filter = new SimpleFilter(this.explorerConfig.getExplorerMode() == 0, this.explorerConfig.getAllowExtensions());
        List<File> files = this.listFiles(this.currentFile, filter);
        this.sortFiles(files, this.explorerConfig.getFileSort());
        for (File file : files) {
            if (!this.explorerConfig.isShowHideDir() && file.getName().startsWith(DIR_ROOT)) continue;
            FileEntity FileEntity2 = new FileEntity();
            if (file.isDirectory()) {
                FileEntity2.setIcon(this.explorerConfig.getFolderIcon());
            } else {
                FileEntity2.setIcon(this.explorerConfig.getFileIcon());
            }
            FileEntity2.setName(file.getName());
            FileEntity2.setFile(file);
            entities.add(FileEntity2);
        }
        long spent = System.currentTimeMillis() - millis;
        DialogLog.print((Object)("spent: " + spent + " ms, async=" + this.explorerConfig.isLoadAsync() + ", thread=" + Thread.currentThread()));
        return entities;
    }

    private List<File> listFiles(File startDir, FileFilter fileFilter) {
        DialogLog.print((Object)String.format("list dir %s by filter %s", startDir, fileFilter.getClass().getName()));
        if (!startDir.isDirectory()) {
            return new ArrayList<File>();
        }
        File[] dirs = startDir.listFiles(fileFilter);
        if (dirs == null) {
            return new ArrayList<File>();
        }
        return Arrays.asList(dirs);
    }

    private void sortFiles(List<File> files, int sort) {
        switch (sort) {
            case 0: {
                Collections.sort(files, new SortByName());
                break;
            }
            case 1: {
                Collections.sort(files, new SortByName());
                Collections.reverse(files);
                break;
            }
            case 2: {
                Collections.sort(files, new SortByTime());
                break;
            }
            case 3: {
                Collections.sort(files, new SortByTime());
                Collections.reverse(files);
                break;
            }
            case 4: {
                Collections.sort(files, new SortBySize());
                break;
            }
            case 5: {
                Collections.sort(files, new SortBySize());
                Collections.reverse(files);
                break;
            }
            case 6: {
                Collections.sort(files, new SortByExtension());
                break;
            }
            case 7: {
                Collections.sort(files, new SortByExtension());
                Collections.reverse(files);
            }
        }
    }
}

