/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.filepicker.ExplorerConfig;
import com.github.gzuliyujiang.filepicker.R;
import com.github.gzuliyujiang.filepicker.adapter.FileAdapter;
import com.github.gzuliyujiang.filepicker.adapter.FileEntity;
import com.github.gzuliyujiang.filepicker.adapter.PathAdapter;
import com.github.gzuliyujiang.filepicker.adapter.ViewHolder;
import com.github.gzuliyujiang.filepicker.contract.OnFileLoadedListener;
import com.github.gzuliyujiang.filepicker.contract.OnPathClickedListener;
import java.io.File;
import java.util.Locale;

public class FileExplorer
extends FrameLayout
implements OnFileLoadedListener,
OnPathClickedListener {
    private CharSequence emptyHint;
    private FileAdapter fileAdapter;
    private PathAdapter pathAdapter;
    private ProgressBar loadingView;
    private RecyclerView fileListView;
    private TextView emptyHintView;
    private RecyclerView pathListView;
    private ExplorerConfig explorerConfig;

    public FileExplorer(Context context) {
        super(context);
        this.init(context);
    }

    public FileExplorer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FileExplorer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @RequiresApi(api=21)
    public FileExplorer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.explorerConfig = new ExplorerConfig(context);
        View contentView = FileExplorer.inflate((Context)context, (int)R.layout.file_picker_content, (ViewGroup)this);
        this.pathListView = (RecyclerView)contentView.findViewById(R.id.file_picker_path_list);
        this.loadingView = (ProgressBar)contentView.findViewById(R.id.file_picker_loading);
        this.fileListView = (RecyclerView)contentView.findViewById(R.id.file_picker_file_list);
        this.emptyHintView = (TextView)contentView.findViewById(R.id.file_picker_empty_hint);
        this.pathAdapter = new PathAdapter(context);
        this.pathAdapter.setOnPathClickedListener(this);
        this.pathListView.setAdapter((RecyclerView.Adapter)this.pathAdapter);
        this.fileAdapter = new FileAdapter(this.explorerConfig);
        this.fileListView.setAdapter((RecyclerView.Adapter)this.fileAdapter);
        this.emptyHint = Locale.getDefault().getDisplayLanguage().contains("\u4e2d\u6587") ? "<\u7a7a>" : "<Empty>";
        this.emptyHintView.setText(this.emptyHint);
    }

    public void load() {
        this.load(null);
    }

    public void load(@Nullable ExplorerConfig config) {
        if (config != null) {
            this.explorerConfig = config;
            this.fileAdapter = new FileAdapter(config);
            this.fileListView.setAdapter((RecyclerView.Adapter)this.fileAdapter);
        }
        this.explorerConfig.setOnFileLoadedListener(this);
        this.explorerConfig.setOnPathClickedListener(this);
        this.refreshCurrent(this.explorerConfig.getRootDir());
    }

    @Override
    public void onFileLoaded(@NonNull File file) {
        this.loadingView.setVisibility(4);
        this.fileListView.setVisibility(0);
        int itemCount = this.fileAdapter.getItemCount();
        if (this.explorerConfig.isShowHomeDir()) {
            --itemCount;
        }
        if (this.explorerConfig.isShowUpDir()) {
            --itemCount;
        }
        if (itemCount < 1) {
            DialogLog.print((Object)"no files, or dir is empty");
            this.emptyHintView.setVisibility(0);
            this.emptyHintView.setText(this.emptyHint);
        } else {
            DialogLog.print((Object)("files or dirs count: " + itemCount));
            this.emptyHintView.setVisibility(4);
        }
        this.pathListView.post(new Runnable(){

            @Override
            public void run() {
                FileExplorer.this.pathListView.scrollToPosition(FileExplorer.this.pathAdapter.getItemCount() - 1);
            }
        });
    }

    @Override
    public void onPathClicked(RecyclerView.Adapter<ViewHolder> adapter, int position, @NonNull String path) {
        DialogLog.print((Object)("clicked path name: " + path));
        if (adapter instanceof PathAdapter) {
            this.refreshCurrent(new File(path));
        } else if (adapter instanceof FileAdapter) {
            FileEntity entity = this.fileAdapter.getItem(position);
            DialogLog.print((Object)("clicked file item: " + entity));
            File file = entity.getFile();
            if (file.isDirectory()) {
                this.refreshCurrent(file);
                return;
            }
            if (this.explorerConfig.getOnFileClickedListener() != null) {
                this.explorerConfig.getOnFileClickedListener().onFileClicked(file);
            }
        }
    }

    public void setEmptyHint(@NonNull CharSequence emptyHint) {
        if (TextUtils.equals((CharSequence)this.emptyHint, (CharSequence)emptyHint)) {
            return;
        }
        this.emptyHint = emptyHint;
        this.emptyHintView.setText(emptyHint);
    }

    public final void refreshCurrent(File current) {
        if (current == null) {
            DialogLog.print((Object)"current dir is null");
            return;
        }
        this.loadingView.setVisibility(0);
        this.fileListView.setVisibility(4);
        this.emptyHintView.setVisibility(4);
        long millis = System.currentTimeMillis();
        this.pathAdapter.updatePath(current);
        this.fileAdapter.loadData(current);
        long spent = System.currentTimeMillis() - millis;
        DialogLog.print((Object)("spent: " + spent + " ms, async=" + this.explorerConfig.isLoadAsync() + ", thread=" + Thread.currentThread()));
    }

    public final FileAdapter getFileAdapter() {
        return this.fileAdapter;
    }

    public final PathAdapter getPathAdapter() {
        return this.pathAdapter;
    }

    public ExplorerConfig getExplorerConfig() {
        return this.explorerConfig;
    }

    public final File getRootDir() {
        return this.explorerConfig.getRootDir();
    }

    public final File getCurrentFile() {
        return this.fileAdapter.getCurrentFile();
    }

    public final RecyclerView getPathListView() {
        return this.pathListView;
    }

    public final RecyclerView getFileListView() {
        return this.fileListView;
    }

    public final TextView getEmptyHintView() {
        return this.emptyHintView;
    }
}

