/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.basepicker.PickerLog;
import com.github.gzuliyujiang.filepicker.R;
import com.github.gzuliyujiang.filepicker.adapter.FileAdapter;
import com.github.gzuliyujiang.filepicker.adapter.FileEntity;
import com.github.gzuliyujiang.filepicker.adapter.PathAdapter;
import com.github.gzuliyujiang.filepicker.contract.OnFileClickedListener;
import com.github.gzuliyujiang.filepicker.contract.OnPathClickedListener;
import java.io.File;
import java.util.Locale;

public class FileExplorer
extends FrameLayout {
    private int explorerMode = 1;
    private File initDir;
    private CharSequence emptyHint;
    private FileAdapter fileAdapter;
    private PathAdapter pathAdapter;
    private RecyclerView fileListView;
    private TextView emptyHintView;
    private View bottomLineView;
    private RecyclerView pathListView;
    private OnFileClickedListener onFileClickedListener;

    public FileExplorer(Context context) {
        super(context);
        this.init(context);
    }

    public FileExplorer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FileExplorer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public FileExplorer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        View contentView = FileExplorer.inflate((Context)context, (int)R.layout.file_picker_content, (ViewGroup)this);
        this.fileListView = (RecyclerView)contentView.findViewById(R.id.file_picker_file_list);
        this.fileAdapter = new FileAdapter(context);
        this.fileListView.setAdapter((RecyclerView.Adapter)this.fileAdapter);
        this.emptyHint = Locale.getDefault().getDisplayLanguage().contains("\u4e2d\u6587") ? "<\u7a7a>" : "<Empty>";
        this.emptyHintView = (TextView)contentView.findViewById(R.id.file_picker_empty_hint);
        this.emptyHintView.setText(this.emptyHint);
        this.bottomLineView = contentView.findViewById(R.id.file_picker_bottom_line);
        this.pathAdapter = new PathAdapter(context);
        this.pathListView = (RecyclerView)contentView.findViewById(R.id.file_picker_path_list);
        this.pathListView.setAdapter((RecyclerView.Adapter)this.pathAdapter);
        this.fileAdapter.setOnlyListDir(false);
        this.fileAdapter.setShowHideDir(true);
        this.fileAdapter.setShowHomeDir(true);
        this.fileAdapter.setShowUpDir(true);
        this.initDir = this.getDefaultDir();
        this.fileAdapter.loadData(this.initDir);
        this.fileAdapter.setOnPathClickedListener(new OnPathClickedListener(){

            @Override
            public void onPathClicked(int position, @NonNull String path) {
                FileEntity entity = FileExplorer.this.fileAdapter.getItem(position);
                PickerLog.print((Object)("clicked file item: " + entity));
                File file = entity.getFile();
                if (file.isDirectory()) {
                    FileExplorer.this.refreshCurrent(file);
                    return;
                }
                if (FileExplorer.this.onFileClickedListener != null) {
                    FileExplorer.this.onFileClickedListener.onFileClicked(file);
                }
            }
        });
        this.pathAdapter.setOnPathClickedListener(new OnPathClickedListener(){

            @Override
            public void onPathClicked(int position, @NonNull String path) {
                PickerLog.print((Object)("clicked path name: " + path));
                FileExplorer.this.refreshCurrent(new File(path));
            }
        });
    }

    public final File getDefaultDir() {
        if (this.initDir != null) {
            return this.initDir;
        }
        if (Environment.getExternalStorageState().equals("mounted")) {
            return this.getContext().getExternalFilesDir(null);
        }
        return this.getContext().getFilesDir();
    }

    public void setInitDir(int explorerMode, File initDir) {
        if (this.explorerMode != explorerMode) {
            this.explorerMode = explorerMode;
            this.fileAdapter.setOnlyListDir(explorerMode == 0);
        }
        if (initDir == null) {
            initDir = this.getDefaultDir();
        }
        this.initDir = initDir;
        this.refreshCurrent(initDir);
    }

    public final int getExplorerMode() {
        return this.explorerMode;
    }

    public void setEmptyHint(@NonNull CharSequence emptyHint) {
        if (TextUtils.equals((CharSequence)this.emptyHint, (CharSequence)emptyHint)) {
            return;
        }
        this.emptyHint = emptyHint;
        this.emptyHintView.setText(emptyHint);
    }

    public final void refreshCurrent(File current) {
        if (current == null) {
            return;
        }
        this.pathAdapter.updatePath(current);
        this.fileAdapter.loadData(current);
        int itemCount = this.fileAdapter.getItemCount();
        if (this.fileAdapter.isShowHomeDir()) {
            --itemCount;
        }
        if (this.fileAdapter.isShowUpDir()) {
            --itemCount;
        }
        if (itemCount < 1) {
            PickerLog.print((Object)"no files, or dir is empty");
            this.emptyHintView.setVisibility(0);
            this.emptyHintView.setText(this.emptyHint);
        } else {
            PickerLog.print((Object)("files or dirs count: " + itemCount));
            this.emptyHintView.setVisibility(8);
        }
    }

    public void setOnFileClickedListener(OnFileClickedListener listener) {
        this.onFileClickedListener = listener;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.fileAdapter.setAllowExtensions(allowExtensions);
    }

    public void setShowUpDir(boolean showUpDir) {
        this.fileAdapter.setShowUpDir(showUpDir);
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.fileAdapter.setShowHomeDir(showHomeDir);
    }

    public void setShowHideDir(boolean showHideDir) {
        this.fileAdapter.setShowHideDir(showHideDir);
    }

    public void setFileIcon(Drawable fileIcon) {
        this.fileAdapter.setFileIcon(fileIcon);
    }

    public void setFolderIcon(Drawable folderIcon) {
        this.fileAdapter.setFolderIcon(folderIcon);
    }

    public void setHomeIcon(Drawable homeIcon) {
        this.fileAdapter.setHomeIcon(homeIcon);
    }

    public void setUpIcon(Drawable upIcon) {
        this.fileAdapter.setUpIcon(upIcon);
    }

    public void setArrowIcon(Drawable arrowIcon) {
        this.pathAdapter.setArrowIcon(arrowIcon);
    }

    public void setItemHeight(int itemHeight) {
        this.fileAdapter.setItemHeight(itemHeight);
    }

    public final FileAdapter getFileAdapter() {
        return this.fileAdapter;
    }

    public final PathAdapter getPathAdapter() {
        return this.pathAdapter;
    }

    public final File getCurrentFile() {
        return this.fileAdapter.getCurrentFile();
    }

    public final RecyclerView getFileListView() {
        return this.fileListView;
    }

    public final TextView getEmptyHintView() {
        return this.emptyHintView;
    }

    public final View getBottomLineView() {
        return this.bottomLineView;
    }

    public final RecyclerView getPathListView() {
        return this.pathListView;
    }
}

