/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.icons.FilePickerIcon;
import cn.qqtheme.framework.util.ConvertUtils;
import java.util.Collections;
import java.util.LinkedList;

public class PathAdapter
extends BaseAdapter {
    private static final String ROOT_HINT = "ROOT";
    private LinkedList<String> paths = new LinkedList();
    private Drawable arrowIcon = null;

    public void setArrowIcon(Drawable arrowIcon) {
        this.arrowIcon = arrowIcon;
    }

    public void updatePath(String path) {
        if (this.arrowIcon == null) {
            this.arrowIcon = ConvertUtils.toDrawable((byte[])FilePickerIcon.getARROW());
        }
        this.paths.clear();
        if (!path.equals("/")) {
            String[] tmps = path.substring(path.indexOf("/") + 1).split("/");
            Collections.addAll(this.paths, tmps);
        }
        this.paths.addFirst(ROOT_HINT);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.paths.size();
    }

    public String getItem(int position) {
        String tmp = "/";
        if (position == 0) {
            return tmp;
        }
        for (int i = 1; i <= position; ++i) {
            tmp = tmp + this.paths.get(i) + "/";
        }
        return tmp;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        Context context = parent.getContext();
        if (convertView == null) {
            int matchParent = -1;
            int wrapContent = -2;
            LinearLayout layout = new LinearLayout(context);
            layout.setOrientation(0);
            layout.setGravity(16);
            if (parent instanceof AbsListView) {
                layout.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(matchParent, matchParent));
            } else {
                layout.setLayoutParams(new ViewGroup.LayoutParams(matchParent, matchParent));
            }
            TextView textView = new TextView(context);
            LinearLayout.LayoutParams tvParams = new LinearLayout.LayoutParams(wrapContent, matchParent);
            textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
            textView.setGravity(8388627);
            int padding = ConvertUtils.toPx((Context)context, (float)5.0f);
            textView.setPadding(padding, 0, padding, 0);
            layout.addView((View)textView);
            ImageView imageView = new ImageView(context);
            int width = ConvertUtils.toPx((Context)context, (float)20.0f);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, matchParent));
            layout.addView((View)imageView);
            convertView = layout;
            holder = new ViewHolder();
            holder.textView = textView;
            holder.imageView = imageView;
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.textView.setText((CharSequence)this.paths.get(position));
        holder.imageView.setImageDrawable(this.arrowIcon);
        return convertView;
    }

    public void recycleData() {
        Bitmap homeBitmap;
        this.paths.clear();
        if (this.arrowIcon instanceof BitmapDrawable && null != (homeBitmap = ((BitmapDrawable)this.arrowIcon).getBitmap()) && !homeBitmap.isRecycled()) {
            homeBitmap.recycle();
        }
    }

    private static class ViewHolder {
        TextView textView;
        ImageView imageView;

        private ViewHolder() {
        }
    }
}

