/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.support.annotation.RequiresPermission;
import android.webkit.MimeTypeMap;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Pattern;

public final class FileUtils {
    public static final int BY_NAME_ASC = 0;
    public static final int BY_NAME_DESC = 1;
    public static final int BY_TIME_ASC = 2;
    public static final int BY_TIME_DESC = 3;
    public static final int BY_SIZE_ASC = 4;
    public static final int BY_SIZE_DESC = 5;
    public static final int BY_EXTENSION_ASC = 6;
    public static final int BY_EXTENSION_DESC = 7;

    public static String separator(String path) {
        String separator = File.separator;
        if (!(path = path.replace("\\", separator)).endsWith(separator)) {
            path = path + separator;
        }
        return path;
    }

    public static void closeSilently(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable t) {
            LogUtils.warn((Throwable)t);
        }
    }

    public static File[] listDirs(String startDirPath, String[] excludeDirs, int sortType) {
        LogUtils.debug((String)String.format("list dir %s", startDirPath));
        ArrayList<File> dirList = new ArrayList<File>();
        File startDir = new File(startDirPath);
        if (!startDir.isDirectory()) {
            return new File[0];
        }
        File[] dirs = startDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                return f.isDirectory();
            }
        });
        if (dirs == null) {
            return new File[0];
        }
        int len = dirs.length;
        if (excludeDirs == null) {
            excludeDirs = new String[]{};
        }
        for (File dir : dirs) {
            File file = dir.getAbsoluteFile();
            if (ConvertUtils.toString((Object[])excludeDirs).contains(file.getName())) continue;
            dirList.add(file);
        }
        if (sortType == 0) {
            Collections.sort(dirList, new SortByName());
        } else if (sortType == 1) {
            Collections.sort(dirList, new SortByName());
            Collections.reverse(dirList);
        } else if (sortType == 2) {
            Collections.sort(dirList, new SortByTime());
        } else if (sortType == 3) {
            Collections.sort(dirList, new SortByTime());
            Collections.reverse(dirList);
        } else if (sortType == 4) {
            Collections.sort(dirList, new SortBySize());
        } else if (sortType == 5) {
            Collections.sort(dirList, new SortBySize());
            Collections.reverse(dirList);
        } else if (sortType == 6) {
            Collections.sort(dirList, new SortByExtension());
        } else if (sortType == 7) {
            Collections.sort(dirList, new SortByExtension());
            Collections.reverse(dirList);
        }
        return dirList.toArray(new File[dirList.size()]);
    }

    public static File[] listDirs(String startDirPath, String[] excludeDirs) {
        return FileUtils.listDirs(startDirPath, excludeDirs, 0);
    }

    public static File[] listDirs(String startDirPath) {
        return FileUtils.listDirs(startDirPath, null, 0);
    }

    public static File[] listDirsAndFiles(String startDirPath, String[] allowExtensions) {
        File[] dirs = FileUtils.listDirs(startDirPath);
        File[] files = allowExtensions == null ? FileUtils.listFiles(startDirPath) : FileUtils.listFiles(startDirPath, allowExtensions);
        if (dirs == null || files == null) {
            return null;
        }
        File[] dirsAndFiles = new File[dirs.length + files.length];
        System.arraycopy(dirs, 0, dirsAndFiles, 0, dirs.length);
        System.arraycopy(files, 0, dirsAndFiles, dirs.length, files.length);
        return dirsAndFiles;
    }

    public static File[] listDirsAndFiles(String startDirPath) {
        return FileUtils.listDirsAndFiles(startDirPath, null);
    }

    public static File[] listFiles(String startDirPath, final Pattern filterPattern, int sortType) {
        LogUtils.debug((String)String.format("list file %s", startDirPath));
        ArrayList<File> fileList = new ArrayList<File>();
        File f = new File(startDirPath);
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return false;
                }
                if (filterPattern == null) {
                    return true;
                }
                return filterPattern.matcher(f.getName()).find();
            }
        });
        if (files == null) {
            return new File[0];
        }
        for (File file : files) {
            fileList.add(file.getAbsoluteFile());
        }
        if (sortType == 0) {
            Collections.sort(fileList, new SortByName());
        } else if (sortType == 1) {
            Collections.sort(fileList, new SortByName());
            Collections.reverse(fileList);
        } else if (sortType == 2) {
            Collections.sort(fileList, new SortByTime());
        } else if (sortType == 3) {
            Collections.sort(fileList, new SortByTime());
            Collections.reverse(fileList);
        } else if (sortType == 4) {
            Collections.sort(fileList, new SortBySize());
        } else if (sortType == 5) {
            Collections.sort(fileList, new SortBySize());
            Collections.reverse(fileList);
        } else if (sortType == 6) {
            Collections.sort(fileList, new SortByExtension());
        } else if (sortType == 7) {
            Collections.sort(fileList, new SortByExtension());
            Collections.reverse(fileList);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static File[] listFiles(String startDirPath, Pattern filterPattern) {
        return FileUtils.listFiles(startDirPath, filterPattern, 0);
    }

    public static File[] listFiles(String startDirPath) {
        return FileUtils.listFiles(startDirPath, null, 0);
    }

    public static File[] listFiles(String startDirPath, final String[] allowExtensions) {
        LogUtils.debug((String)String.format("list file %s", startDirPath));
        File file = new File(startDirPath);
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String extension = FileUtils.getExtension(name);
                return ConvertUtils.toString((Object[])allowExtensions).contains(extension);
            }
        });
    }

    public static File[] listFiles(String startDirPath, String allowExtension) {
        return FileUtils.listFiles(startDirPath, new String[]{allowExtension});
    }

    public static boolean exist(String path) {
        File file = new File(path);
        return file.exists();
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean delete(File file, boolean deleteRootDir) {
        LogUtils.debug((String)String.format("delete file %s", file.getAbsolutePath()));
        boolean result = false;
        if (file.isFile()) {
            result = FileUtils.deleteResolveEBUSY(file);
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                return false;
            }
            if (files.length == 0) {
                result = deleteRootDir && FileUtils.deleteResolveEBUSY(file);
            } else {
                for (File f : files) {
                    FileUtils.delete(f, deleteRootDir);
                    result = FileUtils.deleteResolveEBUSY(f);
                }
            }
            if (deleteRootDir) {
                result = FileUtils.deleteResolveEBUSY(file);
            }
        }
        return result;
    }

    private static boolean deleteResolveEBUSY(File file) {
        File to = new File(file.getAbsolutePath() + System.currentTimeMillis());
        file.renameTo(to);
        return to.delete();
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean delete(String path, boolean deleteRootDir) {
        File file = new File(path);
        if (file.exists()) {
            return FileUtils.delete(file, deleteRootDir);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean delete(String path) {
        return FileUtils.delete(path, false);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean delete(File file) {
        return FileUtils.delete(file, false);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean copy(String src, String tar) {
        File srcFile = new File(src);
        return srcFile.exists() && FileUtils.copy(srcFile, new File(tar));
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean copy(File src, File tar) {
        try {
            LogUtils.debug((String)String.format("copy %s to %s", src.getAbsolutePath(), tar.getAbsolutePath()));
            if (src.isFile()) {
                FileInputStream is = new FileInputStream(src);
                FileOutputStream op = new FileOutputStream(tar);
                BufferedInputStream bis = new BufferedInputStream(is);
                BufferedOutputStream bos = new BufferedOutputStream(op);
                byte[] bt = new byte[8192];
                int len = bis.read(bt);
                while (len != -1) {
                    bos.write(bt, 0, len);
                    len = bis.read(bt);
                }
                bis.close();
                bos.close();
            } else if (src.isDirectory()) {
                File[] files = src.listFiles();
                tar.mkdirs();
                for (File file : files) {
                    FileUtils.copy(file.getAbsoluteFile(), new File(tar.getAbsoluteFile(), file.getName()));
                }
            }
            return true;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean move(String src, String tar) {
        return FileUtils.move(new File(src), new File(tar));
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean move(File src, File tar) {
        return FileUtils.rename(src, tar);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean rename(String oldPath, String newPath) {
        return FileUtils.rename(new File(oldPath), new File(newPath));
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean rename(File src, File tar) {
        try {
            LogUtils.debug((String)String.format("rename %s to %s", src.getAbsolutePath(), tar.getAbsolutePath()));
            return src.renameTo(tar);
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
            return false;
        }
    }

    public static String readText(String filepath, String charset) {
        LogUtils.debug((String)String.format("read %s use %s", filepath, charset));
        try {
            byte[] data = FileUtils.readByte(filepath);
            if (data != null) {
                return new String(data, charset);
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
        return "";
    }

    public static String readText(String filepath) {
        return FileUtils.readText(filepath, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByte(String filepath) {
        byte[] byArray;
        LogUtils.debug((String)String.format("read %s", filepath));
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(filepath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] data = baos.toByteArray();
            baos.close();
            byArray = data;
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                LogUtils.error((Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeSilently(fis);
                throw throwable;
            }
            FileUtils.closeSilently(fis);
            return byArray2;
        }
        FileUtils.closeSilently(fis);
        return byArray;
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean writeText(String filepath, String content, String charset) {
        try {
            FileUtils.writeByte(filepath, content.getBytes(charset));
            return true;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean writeText(String filepath, String content) {
        return FileUtils.writeText(filepath, content, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean writeByte(String filepath, byte[] data) {
        boolean bl;
        LogUtils.debug((String)String.format("write %s", filepath));
        File file = new File(filepath);
        FileOutputStream fos = null;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            fos = new FileOutputStream(filepath);
            fos.write(data);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LogUtils.error((Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeSilently(fos);
                throw throwable;
            }
            FileUtils.closeSilently(fos);
            return bl2;
        }
        FileUtils.closeSilently(fos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean appendText(String path, String content) {
        boolean bl;
        LogUtils.debug((String)String.format("append %s", path));
        File file = new File(path);
        FileWriter writer = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file, true);
            writer.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LogUtils.error((Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeSilently(writer);
                throw throwable;
            }
            FileUtils.closeSilently(writer);
            return bl2;
        }
        FileUtils.closeSilently(writer);
        return bl;
    }

    public static long getLength(String path) {
        File file = new File(path);
        if (!file.isFile() || !file.exists()) {
            return 0L;
        }
        return file.length();
    }

    public static String getSize(String path) {
        long fileSize = FileUtils.getLength(path);
        return ConvertUtils.toFileSizeString((long)fileSize);
    }

    public static String getExtension(String pathOrUrl) {
        int dotPos = pathOrUrl.lastIndexOf(46);
        if (0 <= dotPos) {
            return pathOrUrl.substring(dotPos + 1);
        }
        return "ext";
    }

    public static String getMimeType(String pathOrUrl) {
        String ext = FileUtils.getExtension(pathOrUrl);
        MimeTypeMap map = MimeTypeMap.getSingleton();
        String mimeType = map.hasExtension(ext) ? map.getMimeTypeFromExtension(ext) : "*/*";
        LogUtils.debug((String)(pathOrUrl + ": " + mimeType));
        return mimeType;
    }

    public static String getDateTime(String path) {
        return FileUtils.getDateTime(path, "yyyy\u5e74MM\u6708dd\u65e5HH:mm");
    }

    public static String getDateTime(String path, String format) {
        File file = new File(path);
        return FileUtils.getDateTime(file, format);
    }

    public static String getDateTime(File file, String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(file.lastModified());
        SimpleDateFormat chineseDateFormat = new SimpleDateFormat(format, Locale.CHINA);
        return chineseDateFormat.format(cal.getTime());
    }

    public static int compareLastModified(String path1, String path2) {
        long stamp2;
        long stamp1 = new File(path1).lastModified();
        if (stamp1 > (stamp2 = new File(path2).lastModified())) {
            return 1;
        }
        if (stamp1 < stamp2) {
            return -1;
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean makeDirs(String path) {
        return FileUtils.makeDirs(new File(path));
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static boolean makeDirs(File file) {
        return file.mkdirs();
    }

    public static class SortByTime
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            if (f1.lastModified() > f2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }

    public static class SortBySize
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            if (f1.length() < f2.length()) {
                return -1;
            }
            return 1;
        }
    }

    public static class SortByName
    implements Comparator<File> {
        private boolean caseSensitive;

        public SortByName(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public SortByName() {
            this.caseSensitive = false;
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            String s1 = f1.getName();
            String s2 = f2.getName();
            if (this.caseSensitive) {
                return s1.compareTo(s2);
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class SortByExtension
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            return f1.getName().compareToIgnoreCase(f2.getName());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SortType {
    }
}

