/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.BaseDialog;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.dialog.R;

public abstract class BottomDialog
extends BaseDialog {
    protected View maskView;

    public BottomDialog(@NonNull Activity activity) {
        super(activity, R.style.DialogTheme_Sheet);
    }

    public BottomDialog(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @Override
    public void onInit(@Nullable Bundle savedInstanceState) {
        super.onInit(savedInstanceState);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.setWidth(this.activity.getResources().getDisplayMetrics().widthPixels);
        this.setGravity(80);
    }

    @Override
    public void onShow(DialogInterface dialog) {
        super.onShow(dialog);
        if (this.enableMaskView()) {
            this.addMaskView();
        }
    }

    protected boolean enableMaskView() {
        return true;
    }

    protected void addMaskView() {
        try {
            this.getWindow().setDimAmount(0.0f);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = -1;
            Point screenRealSize = new Point();
            this.activity.getWindowManager().getDefaultDisplay().getRealSize(screenRealSize);
            int navBarIdentifier = this.activity.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
            params.height = screenRealSize.y - this.activity.getResources().getDimensionPixelSize(navBarIdentifier);
            params.gravity = 48;
            if (Build.VERSION.SDK_INT >= 28) {
                params.layoutInDisplayCutoutMode = 1;
            }
            params.systemUiVisibility = 1280;
            params.type = 1000;
            params.format = -3;
            params.token = this.activity.getWindow().getDecorView().getWindowToken();
            params.softInputMode = 18;
            this.maskView = new View((Context)this.activity);
            this.maskView.setBackgroundColor(0x7F000000);
            this.maskView.setFitsSystemWindows(false);
            this.maskView.setOnKeyListener((view, keyCode, event) -> {
                if (keyCode == 4) {
                    this.dismiss();
                    return true;
                }
                return false;
            });
            this.activity.getWindowManager().addView(this.maskView, (ViewGroup.LayoutParams)params);
            DialogLog.print("dialog add mask view");
        }
        catch (Throwable e) {
            DialogLog.print(e);
        }
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        this.removeMaskView();
        super.onDismiss(dialog);
    }

    protected void removeMaskView() {
        if (this.maskView == null) {
            DialogLog.print("mask view is null");
            return;
        }
        try {
            this.activity.getWindowManager().removeViewImmediate(this.maskView);
            DialogLog.print("dialog remove mask view");
        }
        catch (Throwable e) {
            DialogLog.print(e);
        }
        this.maskView = null;
    }
}

