/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.github.gzuliyujiang.dialog.CornerRound;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.dialog.R;

public abstract class BaseDialog
extends Dialog
implements DialogInterface.OnShowListener,
DialogInterface.OnDismissListener,
LifecycleEventObserver {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    protected Activity activity;
    protected View contentView;

    public BaseDialog(@NonNull Activity activity) {
        this(activity, R.style.DialogTheme_Base);
    }

    public BaseDialog(@NonNull Activity activity, @StyleRes int themeResId) {
        super((Context)activity, themeResId);
        this.init(activity);
    }

    public final View getContentView() {
        return this.contentView;
    }

    private void init(Activity activity) {
        if (activity instanceof LifecycleOwner) {
            ((LifecycleOwner)activity).getLifecycle().addObserver((LifecycleObserver)this);
        }
        this.activity = activity;
        this.setCanceledOnTouchOutside(false);
        this.setCancelable(false);
        super.setOnShowListener((DialogInterface.OnShowListener)this);
        super.setOnDismissListener((DialogInterface.OnDismissListener)this);
        Window window = super.getWindow();
        if (window != null) {
            window.requestFeature(1);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.setLayout(activity.getResources().getDisplayMetrics().widthPixels, -2);
            window.setGravity(17);
            window.getDecorView().setPadding(0, 0, 0, 0);
        }
        this.onInit(null);
        if (Build.VERSION.SDK_INT >= 21) {
            super.create();
        } else {
            this.readyView();
        }
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        if (event.equals((Object)Lifecycle.Event.ON_DESTROY)) {
            DialogLog.print("dismiss dialog when " + source.getClass().getName() + " on destroy");
            this.dismiss();
            source.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }

    @Deprecated
    @CallSuper
    protected void onInit(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        DialogLog.print("dialog onInit");
    }

    @CallSuper
    protected void onInit(@Nullable Bundle savedInstanceState) {
        this.onInit(this.activity, savedInstanceState);
    }

    protected final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        DialogLog.print("dialog onCreate");
        if (this.contentView == null) {
            this.readyView();
        }
    }

    private void readyView() {
        this.contentView = this.createContentView();
        this.contentView.setFocusable(true);
        this.contentView.setFocusableInTouchMode(true);
        this.setContentView(this.contentView);
        this.initView();
    }

    @NonNull
    protected abstract View createContentView();

    @Deprecated
    @CallSuper
    protected void initView(View contentView) {
        DialogLog.print("dialog initView");
    }

    @CallSuper
    protected void initView() {
        this.initView(this.contentView);
    }

    public final void disableCancel() {
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public final void setBackgroundColor(@ColorInt int color) {
        this.setBackgroundColor(0, color);
    }

    public final void setBackgroundColor(@CornerRound int cornerRound, @ColorInt int color) {
        this.setBackgroundColor(cornerRound, 20, color);
    }

    public final void setBackgroundColor(@CornerRound int cornerRound, @Dimension(unit=0) int radius, @ColorInt int color) {
        ColorDrawable drawable;
        if (this.contentView == null) {
            return;
        }
        float radiusInPX = this.contentView.getResources().getDisplayMetrics().density * (float)radius;
        this.contentView.setLayerType(1, null);
        switch (cornerRound) {
            case 1: {
                float[] outerRadii = new float[]{radiusInPX, radiusInPX, radiusInPX, radiusInPX, 0.0f, 0.0f, 0.0f, 0.0f};
                ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RoundRectShape(outerRadii, null, null));
                shapeDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                drawable = shapeDrawable;
                break;
            }
            case 2: {
                GradientDrawable gradientDrawable = new GradientDrawable();
                gradientDrawable.setCornerRadius(radiusInPX);
                gradientDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                drawable = gradientDrawable;
                break;
            }
            default: {
                drawable = new ColorDrawable(color);
            }
        }
        this.contentView.setBackground((Drawable)drawable);
    }

    public final void setBackgroundResource(@DrawableRes int resId) {
        if (this.contentView == null) {
            return;
        }
        this.contentView.setBackgroundResource(resId);
    }

    public final void setBackgroundDrawable(Drawable drawable) {
        if (this.contentView == null) {
            return;
        }
        this.contentView.setBackground(drawable);
    }

    public final void setLayout(int width, int height) {
        this.getWindow().setLayout(width, height);
    }

    public final void setWidth(int width) {
        this.getWindow().setLayout(width, this.getWindow().getAttributes().height);
    }

    public final void setHeight(int height) {
        this.getWindow().setLayout(this.getWindow().getAttributes().width, height);
    }

    public final void setGravity(int gravity) {
        this.getWindow().setGravity(gravity);
    }

    public final void setDimAmount(@FloatRange(from=0.0, to=1.0) float amount) {
        this.getWindow().setDimAmount(amount);
    }

    public final void setAnimationStyle(@StyleRes int animRes) {
        this.getWindow().setWindowAnimations(animRes);
    }

    public void setOnShowListener(@Nullable DialogInterface.OnShowListener listener) {
        if (listener == null) {
            return;
        }
        BaseDialog current = this;
        super.setOnShowListener(dialog -> {
            current.onShow(dialog);
            listener.onShow(dialog);
        });
    }

    public void setOnDismissListener(@Nullable DialogInterface.OnDismissListener listener) {
        if (listener == null) {
            return;
        }
        BaseDialog current = this;
        super.setOnDismissListener(dialog -> {
            current.onDismiss(dialog);
            listener.onDismiss(dialog);
        });
    }

    @CallSuper
    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.showSafe();
    }

    protected void showSafe() {
        try {
            super.show();
            DialogLog.print("dialog show");
        }
        catch (Throwable e) {
            DialogLog.print(e);
        }
    }

    @CallSuper
    public void dismiss() {
        if (!this.isShowing()) {
            return;
        }
        this.dismissSafe();
    }

    protected void dismissSafe() {
        try {
            super.dismiss();
            DialogLog.print("dialog dismiss");
        }
        catch (Throwable e) {
            DialogLog.print(e);
        }
    }

    @CallSuper
    public void onAttachedToWindow() {
        DialogLog.print("dialog attached to window");
        super.onAttachedToWindow();
        this.initData();
    }

    @CallSuper
    protected void initData() {
        DialogLog.print("dialog initData");
    }

    @CallSuper
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        DialogLog.print("dialog detached from window");
    }

    @CallSuper
    public void onShow(DialogInterface dialog) {
        DialogLog.print("dialog onShow");
    }

    @CallSuper
    public void onDismiss(DialogInterface dialog) {
        DialogLog.print("dialog onDismiss");
    }
}

