/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.dialog;

import android.app.Activity;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Dimension;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.graphics.ColorUtils;
import com.github.gzuliyujiang.dialog.BottomDialog;
import com.github.gzuliyujiang.dialog.DialogConfig;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.dialog.R;

public abstract class ModalDialog
extends BottomDialog
implements View.OnClickListener {
    protected View headerView;
    protected TextView cancelView;
    protected TextView titleView;
    protected TextView okView;
    protected View topLineView;
    protected View bodyView;
    protected View footerView;

    public ModalDialog(@NonNull Activity activity) {
        super(activity, DialogConfig.getDialogStyle() == 3 ? R.style.DialogTheme_Fade : R.style.DialogTheme_Sheet);
    }

    public ModalDialog(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @Override
    public void onInit(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        super.onInit(activity, savedInstanceState);
        if (DialogConfig.getDialogStyle() == 3) {
            this.setWidth((int)((float)activity.getResources().getDisplayMetrics().widthPixels * 0.8f));
            this.setGravity(17);
        }
    }

    @Override
    protected boolean enableMaskView() {
        return DialogConfig.getDialogStyle() != 3;
    }

    @Override
    @NonNull
    protected View createContentView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setGravity(17);
        rootLayout.setPadding(0, 0, 0, 0);
        this.headerView = this.createHeaderView();
        if (this.headerView == null) {
            this.headerView = new View((Context)this.activity);
            this.headerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
        }
        rootLayout.addView(this.headerView);
        this.topLineView = this.createTopLineView();
        if (this.topLineView == null) {
            this.topLineView = new View((Context)this.activity);
            this.topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
        }
        rootLayout.addView(this.topLineView);
        this.bodyView = this.createBodyView();
        rootLayout.addView(this.bodyView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        this.footerView = this.createFooterView();
        if (this.footerView == null) {
            this.footerView = new View((Context)this.activity);
            this.footerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
        }
        rootLayout.addView(this.footerView);
        return rootLayout;
    }

    @Nullable
    protected View createHeaderView() {
        switch (DialogConfig.getDialogStyle()) {
            case 1: {
                return View.inflate((Context)this.activity, (int)R.layout.dialog_header_style_1, null);
            }
            case 2: {
                return View.inflate((Context)this.activity, (int)R.layout.dialog_header_style_2, null);
            }
            case 3: {
                return View.inflate((Context)this.activity, (int)R.layout.dialog_header_style_3, null);
            }
        }
        return View.inflate((Context)this.activity, (int)R.layout.dialog_header_style_default, null);
    }

    @Nullable
    protected View createTopLineView() {
        if (DialogConfig.getDialogStyle() == 0) {
            View view = new View((Context)this.activity);
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, (int)(1.0f * this.activity.getResources().getDisplayMetrics().density)));
            view.setBackgroundColor(DialogConfig.getDialogColor().topLineColor());
            return view;
        }
        return null;
    }

    @NonNull
    protected abstract View createBodyView();

    @Nullable
    protected View createFooterView() {
        switch (DialogConfig.getDialogStyle()) {
            case 1: {
                return View.inflate((Context)this.activity, (int)R.layout.dialog_footer_style_1, null);
            }
            case 2: {
                return View.inflate((Context)this.activity, (int)R.layout.dialog_footer_style_2, null);
            }
            case 3: {
                return View.inflate((Context)this.activity, (int)R.layout.dialog_footer_style_3, null);
            }
        }
        return null;
    }

    @Override
    @CallSuper
    protected void initView(@NonNull View contentView) {
        super.initView(contentView);
        int color = DialogConfig.getDialogColor().contentBackgroundColor();
        switch (DialogConfig.getDialogStyle()) {
            case 1: 
            case 2: {
                this.setBackgroundColor(1, color);
                break;
            }
            case 3: {
                this.setBackgroundColor(2, color);
                break;
            }
            default: {
                this.setBackgroundColor(0, color);
            }
        }
        this.cancelView = (TextView)contentView.findViewById(R.id.dialog_modal_cancel);
        if (this.cancelView == null) {
            throw new IllegalArgumentException("Cancel view id not found");
        }
        this.titleView = (TextView)contentView.findViewById(R.id.dialog_modal_title);
        if (this.titleView == null) {
            throw new IllegalArgumentException("Title view id not found");
        }
        this.okView = (TextView)contentView.findViewById(R.id.dialog_modal_ok);
        if (this.okView == null) {
            throw new IllegalArgumentException("Ok view id not found");
        }
    }

    @Override
    @CallSuper
    protected void initData() {
        super.initData();
        this.titleView.setTextColor(DialogConfig.getDialogColor().titleTextColor());
        this.cancelView.setTextColor(DialogConfig.getDialogColor().cancelTextColor());
        this.okView.setTextColor(DialogConfig.getDialogColor().okTextColor());
        this.cancelView.setOnClickListener((View.OnClickListener)this);
        this.okView.setOnClickListener((View.OnClickListener)this);
        this.maybeBuildEllipseButton();
    }

    private void maybeBuildEllipseButton() {
        if (DialogConfig.getDialogStyle() != 1 && DialogConfig.getDialogStyle() != 2) {
            return;
        }
        if (DialogConfig.getDialogStyle() == 2) {
            Drawable background = this.cancelView.getBackground();
            if (background != null) {
                background.setColorFilter((ColorFilter)new PorterDuffColorFilter(DialogConfig.getDialogColor().cancelEllipseColor(), PorterDuff.Mode.SRC_IN));
                this.cancelView.setBackground(background);
            } else {
                this.cancelView.setBackgroundResource(R.mipmap.dialog_close_icon);
            }
        } else {
            GradientDrawable cancelDrawable = new GradientDrawable();
            cancelDrawable.setCornerRadius(this.okView.getResources().getDisplayMetrics().density * 999.0f);
            cancelDrawable.setColor(DialogConfig.getDialogColor().cancelEllipseColor());
            this.cancelView.setBackground((Drawable)cancelDrawable);
            if (ColorUtils.calculateLuminance((int)DialogConfig.getDialogColor().cancelEllipseColor()) < 0.5) {
                this.cancelView.setTextColor(-1);
            } else {
                this.cancelView.setTextColor(-10066330);
            }
        }
        GradientDrawable okDrawable = new GradientDrawable();
        okDrawable.setCornerRadius(this.okView.getResources().getDisplayMetrics().density * 999.0f);
        okDrawable.setColor(DialogConfig.getDialogColor().okEllipseColor());
        this.okView.setBackground((Drawable)okDrawable);
        if (ColorUtils.calculateLuminance((int)DialogConfig.getDialogColor().okEllipseColor()) < 0.5) {
            this.okView.setTextColor(-1);
        } else {
            this.okView.setTextColor(-13421773);
        }
    }

    @CallSuper
    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.dialog_modal_cancel) {
            DialogLog.print("cancel clicked");
            this.onCancel();
            this.dismiss();
        } else if (id2 == R.id.dialog_modal_ok) {
            DialogLog.print("ok clicked");
            this.onOk();
            this.dismiss();
        }
    }

    protected abstract void onCancel();

    protected abstract void onOk();

    public final void setBodyWidth(@Dimension(unit=0) @IntRange(from=50L) int bodyWidth) {
        ViewGroup.LayoutParams layoutParams = this.bodyView.getLayoutParams();
        int width = -2;
        if (bodyWidth != -2 && bodyWidth != -1) {
            width = (int)(this.bodyView.getResources().getDisplayMetrics().density * (float)bodyWidth);
        }
        layoutParams.width = width;
        this.bodyView.setLayoutParams(layoutParams);
    }

    public final void setBodyHeight(@Dimension(unit=0) @IntRange(from=50L) int bodyHeight) {
        ViewGroup.LayoutParams layoutParams = this.bodyView.getLayoutParams();
        int height = -2;
        if (bodyHeight != -2 && bodyHeight != -1) {
            height = (int)(this.bodyView.getResources().getDisplayMetrics().density * (float)bodyHeight);
        }
        layoutParams.height = height;
        this.bodyView.setLayoutParams(layoutParams);
    }

    public final View getHeaderView() {
        if (this.headerView == null) {
            this.headerView = new View((Context)this.activity);
        }
        return this.headerView;
    }

    public final View getTopLineView() {
        return this.topLineView;
    }

    public final View getBodyView() {
        return this.bodyView;
    }

    public final View getFooterView() {
        return this.footerView;
    }

    public final TextView getCancelView() {
        return this.cancelView;
    }

    public final TextView getTitleView() {
        return this.titleView;
    }

    public final TextView getOkView() {
        return this.okView;
    }
}

