/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.basepicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Dimension;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.BottomDialog;
import com.github.gzuliyujiang.basepicker.PickerLog;
import com.github.gzuliyujiang.basepicker.R;

public abstract class ConfirmPicker
extends BottomDialog
implements View.OnClickListener {
    protected View headerView;
    protected TextView cancelView;
    protected TextView titleView;
    protected TextView okView;
    protected View topLineView;
    protected View bodyView;
    protected View footerView;

    public ConfirmPicker(@NonNull Activity activity) {
        super(activity);
    }

    public ConfirmPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @Override
    @NonNull
    protected View createContentView(@NonNull Activity activity) {
        LinearLayout rootLayout = new LinearLayout((Context)activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setGravity(17);
        rootLayout.setPadding(0, 0, 0, 0);
        rootLayout.setBackgroundColor(-1);
        this.headerView = this.createHeaderView(activity);
        if (this.headerView != null) {
            rootLayout.addView(this.headerView);
        }
        this.topLineView = this.createTopLineView(activity);
        if (this.topLineView != null) {
            rootLayout.addView(this.topLineView);
        }
        this.bodyView = this.createBodyView(activity);
        rootLayout.addView(this.bodyView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        this.footerView = this.createFooterView(activity);
        if (this.footerView != null) {
            rootLayout.addView(this.footerView);
        }
        return rootLayout;
    }

    @Nullable
    protected View createHeaderView(@NonNull Activity activity) {
        return View.inflate((Context)activity, (int)R.layout.confirm_picker_header, null);
    }

    @Nullable
    protected View createTopLineView(@NonNull Activity activity) {
        View view = new View((Context)activity);
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        view.setBackgroundColor(-3355444);
        return view;
    }

    @NonNull
    protected abstract View createBodyView(@NonNull Activity var1);

    @Nullable
    protected View createFooterView(@NonNull Activity activity) {
        return null;
    }

    @Override
    @CallSuper
    protected void initView(@NonNull View contentView) {
        super.initView(contentView);
        this.cancelView = (TextView)contentView.findViewById(R.id.confirm_picker_cancel);
        this.titleView = (TextView)contentView.findViewById(R.id.confirm_picker_title);
        this.okView = (TextView)contentView.findViewById(R.id.confirm_picker_ok);
    }

    @Override
    @CallSuper
    protected void initData() {
        super.initData();
        if (this.cancelView != null) {
            this.cancelView.setOnClickListener((View.OnClickListener)this);
        }
        if (this.okView != null) {
            this.okView.setOnClickListener((View.OnClickListener)this);
        }
    }

    @CallSuper
    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.confirm_picker_cancel) {
            PickerLog.print("cancel clicked");
            this.onCancel();
            this.dismiss();
        } else if (id2 == R.id.confirm_picker_ok) {
            PickerLog.print("ok clicked");
            this.onOk();
            this.dismiss();
        }
    }

    protected abstract void onCancel();

    protected abstract void onOk();

    public final void setBodyWidth(@Dimension(unit=0) @IntRange(from=50L) int bodyWidth) {
        ViewGroup.LayoutParams layoutParams = this.bodyView.getLayoutParams();
        int width = -2;
        if (bodyWidth != -2 && bodyWidth != -1) {
            width = (int)(this.bodyView.getResources().getDisplayMetrics().density * (float)bodyWidth);
        }
        layoutParams.width = width;
        this.bodyView.setLayoutParams(layoutParams);
    }

    public final void setBodyHeight(@Dimension(unit=0) @IntRange(from=50L) int bodyHeight) {
        ViewGroup.LayoutParams layoutParams = this.bodyView.getLayoutParams();
        int height = -2;
        if (bodyHeight != -2 && bodyHeight != -1) {
            height = (int)(this.bodyView.getResources().getDisplayMetrics().density * (float)bodyHeight);
        }
        layoutParams.height = height;
        this.bodyView.setLayoutParams(layoutParams);
    }

    public final View getHeaderView() {
        return this.headerView;
    }

    public final View getTopLineView() {
        return this.topLineView;
    }

    public final View getBodyView() {
        return this.bodyView;
    }

    public final View getFooterView() {
        return this.footerView;
    }

    public final TextView getCancelView() {
        return this.cancelView;
    }

    public final TextView getTitleView() {
        return this.titleView;
    }

    public final TextView getOkView() {
        return this.okView;
    }
}

