/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import androidx.annotation.NonNull;
import cn.qqtheme.framework.util.LogUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtils
extends android.text.format.DateUtils {
    public static final int Second = 0;
    public static final int Minute = 1;
    public static final int Hour = 2;
    public static final int Day = 3;

    public static long calculateDifferentSecond(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, 0);
    }

    public static long calculateDifferentMinute(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, 1);
    }

    public static long calculateDifferentHour(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, 2);
    }

    public static long calculateDifferentDay(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, 3);
    }

    public static long calculateDifferentSecond(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, 0);
    }

    public static long calculateDifferentMinute(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, 1);
    }

    public static long calculateDifferentHour(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, 2);
    }

    public static long calculateDifferentDay(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, 3);
    }

    public static long calculateDifference(long startTimeMillis, long endTimeMillis, int mode) {
        return DateUtils.calculateDifference(new Date(startTimeMillis), new Date(endTimeMillis), mode);
    }

    public static long calculateDifference(Date startDate, Date endDate, int mode) {
        long[] different = DateUtils.calculateDifference(startDate, endDate);
        if (mode == 1) {
            return different[2];
        }
        if (mode == 2) {
            return different[1];
        }
        if (mode == 3) {
            return different[0];
        }
        return different[3];
    }

    private static long[] calculateDifference(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(endDate.getTime() - startDate.getTime());
    }

    private static long[] calculateDifference(long differentMilliSeconds) {
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long daysInMilli = hoursInMilli * 24L;
        long elapsedDays = differentMilliSeconds / daysInMilli;
        long elapsedHours = (differentMilliSeconds %= daysInMilli) / hoursInMilli;
        long elapsedMinutes = (differentMilliSeconds %= hoursInMilli) / minutesInMilli;
        long elapsedSeconds = (differentMilliSeconds %= minutesInMilli) / secondsInMilli;
        LogUtils.verbose(String.format(Locale.CHINA, "different: %d ms, %d days, %d hours, %d minutes, %d seconds", differentMilliSeconds, elapsedDays, elapsedHours, elapsedMinutes, elapsedSeconds));
        return new long[]{elapsedDays, elapsedHours, elapsedMinutes, elapsedSeconds};
    }

    public static int calculateDaysInMonth(int month) {
        return DateUtils.calculateDaysInMonth(0, month);
    }

    public static int calculateDaysInMonth(int year, int month) {
        String[] bigMonths = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] littleMonths = new String[]{"4", "6", "9", "11"};
        List<String> bigList = Arrays.asList(bigMonths);
        List<String> littleList = Arrays.asList(littleMonths);
        if (bigList.contains(String.valueOf(month))) {
            return 31;
        }
        if (littleList.contains(String.valueOf(month))) {
            return 30;
        }
        if (year <= 0) {
            return 29;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return 29;
        }
        return 28;
    }

    @NonNull
    public static String fillZero(int number) {
        return number < 10 ? "0" + number : "" + number;
    }

    public static int trimZero(@NonNull String text) {
        try {
            if (text.startsWith("0")) {
                text = text.substring(1);
            }
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            LogUtils.warn(e);
            return 0;
        }
    }

    public static boolean isSameDay(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        Calendar nowCalendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTime(date);
        return nowCalendar.get(0) == newCalendar.get(0) && nowCalendar.get(1) == newCalendar.get(1) && nowCalendar.get(6) == newCalendar.get(6);
    }

    public static Date parseDate(String dateStr, String dataFormat) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dataFormat, Locale.PRC);
            Date date = dateFormat.parse(dateStr);
            return new Date(date.getTime());
        }
        catch (ParseException e) {
            LogUtils.warn(e);
            return null;
        }
    }

    public static Date parseDate(String dateStr) {
        return DateUtils.parseDate(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.PRC);
        return sdf.format(date);
    }

    public static String formatDate(String format) {
        return DateUtils.formatDate(Calendar.getInstance(Locale.CHINA).getTime(), format);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DifferenceMode {
    }
}

